/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.osm;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import org.neo4j.collections.rtree.filter.SearchAll;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.filter.SearchRecords;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeline;
import org.neo4j.gis.spatial.pipes.osm.filtering.FilterOSMAttributes;
import org.neo4j.gis.spatial.pipes.osm.processing.ExtractOSMPoints;

public class OSMGeoPipeline
extends GeoPipeline {
    protected OSMGeoPipeline(Layer layer) {
        super(layer);
    }

    public static OSMGeoPipeline startOsm(Layer layer, SearchRecords records) {
        OSMGeoPipeline pipeline = new OSMGeoPipeline(layer);
        return (OSMGeoPipeline)pipeline.add((Pipe)OSMGeoPipeline.createStartPipe(records));
    }

    public static OSMGeoPipeline startOsm(Layer layer, SearchFilter searchFilter) {
        return OSMGeoPipeline.startOsm(layer, layer.getIndex().search(searchFilter));
    }

    public static OSMGeoPipeline startOsm(Layer layer) {
        return OSMGeoPipeline.startOsm(layer, (SearchFilter)new SearchAll());
    }

    public OSMGeoPipeline addOsmPipe(AbstractGeoPipe geoPipe) {
        return (OSMGeoPipeline)this.add((Pipe)geoPipe);
    }

    public OSMGeoPipeline extractOsmPoints() {
        return this.addOsmPipe(new ExtractOSMPoints(this.layer.getGeometryFactory()));
    }

    public OSMGeoPipeline osmAttributeFilter(String key, Object value) {
        return this.addOsmPipe(new FilterOSMAttributes(key, value));
    }

    public OSMGeoPipeline osmAttributeFilter(String key, String value, FilterPipe.Filter comparison) {
        return this.addOsmPipe(new FilterOSMAttributes(key, value, comparison));
    }
}

