/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.osm.processing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import org.neo4j.gis.spatial.osm.OSMRelation;
import org.neo4j.gis.spatial.pipes.AbstractExtractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.OrderedByTypeExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

public class ExtractOSMPoints
extends AbstractExtractGeoPipe {
    private GeometryFactory geomFactory;

    public ExtractOSMPoints(GeometryFactory geomFactory) {
        this.geomFactory = geomFactory;
    }

    @Override
    protected void extract(GeoPipeFlow pipeFlow) {
        Node geomNode = pipeFlow.getRecord().getGeomNode();
        Node node = geomNode.getSingleRelationship((RelationshipType)OSMRelation.GEOM, Direction.INCOMING).getStartNode();
        TraversalDescription td = Traversal.description().evaluator(new Evaluator(){

            public Evaluation evaluate(Path path) {
                if (path.length() > 0 && !((Relationship)path.relationships().iterator().next()).isType((RelationshipType)OSMRelation.NEXT) && path.lastRelationship().isType((RelationshipType)OSMRelation.NODE)) {
                    return Evaluation.INCLUDE_AND_PRUNE;
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        }).expand((RelationshipExpander)new OrderedByTypeExpander().add((RelationshipType)OSMRelation.FIRST_NODE, Direction.OUTGOING).add((RelationshipType)OSMRelation.NEXT, Direction.OUTGOING).add((RelationshipType)OSMRelation.NODE, Direction.OUTGOING)).uniqueness((UniquenessFactory)Uniqueness.NODE_PATH);
        int counter = 0;
        for (Path path : td.traverse(node)) {
            Node pointNode = path.endNode();
            double longitude = (Double)pointNode.getProperty("lon");
            double latitude = (Double)pointNode.getProperty("lat");
            GeoPipeFlow newPoint = pipeFlow.makeClone("osmpoint" + counter++);
            newPoint.setGeometry((Geometry)this.geomFactory.createPoint(new Coordinate(longitude, latitude)));
            this.extracts.add(newPoint);
        }
    }
}

