/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.processing;

import org.neo4j.gis.spatial.pipes.AbstractGroupGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;

public class DensityIslands
extends AbstractGroupGeoPipe {
    private double density;

    public DensityIslands(double density) {
        this.density = density;
    }

    @Override
    protected void group(GeoPipeFlow pipeFlow) {
        boolean islandFound = false;
        for (int i = 0; i < this.groups.size() && !islandFound; ++i) {
            if (!(pipeFlow.getGeometry().distance(((GeoPipeFlow)this.groups.get(i)).getGeometry()) <= this.density)) continue;
            ((GeoPipeFlow)this.groups.get(i)).setGeometry(((GeoPipeFlow)this.groups.get(i)).getGeometry().union(pipeFlow.getGeometry()));
            ((GeoPipeFlow)this.groups.get(i)).merge(pipeFlow);
            islandFound = true;
        }
        if (!islandFound) {
            this.groups.add(pipeFlow);
        }
    }
}

