/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.server.plugin;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import org.neo4j.gis.spatial.DynamicLayer;
import org.neo4j.gis.spatial.EditableLayer;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.pipes.GeoPipeline;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;

@Description(value="a set of extensions that perform operations using the neo4j-spatial component")
public class SpatialPlugin
extends ServerPlugin {
    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="add a new layer specialized at storing simple point location data")
    public Iterable<Node> addSimplePointLayer(@Source GraphDatabaseService db, @Description(value="The layer to find or create.") @Parameter(name="layer") String layer, @Description(value="The node property that contains the latitude. Default is 'lat'") @Parameter(name="lat", optional=true) String lat, @Description(value="The node property that contains the longitude. Default is 'lon'") @Parameter(name="lon", optional=true) String lon) {
        System.out.println("Creating new layer '" + layer + "' unless it already exists");
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        return this.toArray(spatialService.getOrCreatePointLayer(layer, lon, lat).getLayerNode());
    }

    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="add a new layer specialized at storing generic geometry data in WKB")
    public Iterable<Node> addEditableLayer(@Source GraphDatabaseService db, @Description(value="The layer to find or create.") @Parameter(name="layer") String layer, @Description(value="The format for internal representation, either WKB or WKT") @Parameter(name="format", optional=true) String format) {
        System.out.println("Creating new layer '" + layer + "' unless it already exists");
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        return this.toArray(spatialService.getOrCreateEditableLayer(layer).getLayerNode());
    }

    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="add a new dynamic layer exposing a filtered view of an existing layer")
    public Iterable<Node> addCQLDynamicLayer(@Source GraphDatabaseService db, @Description(value="The master layer to find") @Parameter(name="master_layer") String master_layer, @Description(value="The name for the new dynamic layer") @Parameter(name="name") String name, @Description(value="The type of geometry to use for streaming data from the new view") @Parameter(name="geometry", optional=true) String geometry, @Description(value="The CQL query to use for defining this dynamic layer") @Parameter(name="layer") String query) {
        System.out.println("Creating new dynamic layer '" + name + "' from existing layer '" + master_layer + "'");
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        DynamicLayer dynamicLayer = spatialService.asDynamicLayer(spatialService.getLayer(master_layer));
        int gtype = SpatialDatabaseService.convertGeometryNameToType(geometry);
        return this.toArray(dynamicLayer.addLayerConfig(name, gtype, query).getLayerNode());
    }

    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="find an existing layer")
    public Iterable<Node> getLayer(@Source GraphDatabaseService db, @Description(value="The layer to find.") @Parameter(name="layer") String layer) {
        System.out.println("Finding layer '" + layer + "'");
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        return this.toArray(spatialService.getLayer(layer).getLayerNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="add a geometry node to a layer, as long as the node contains the geometry information appropriate to this layer.")
    public Iterable<Node> addNodeToLayer(@Source GraphDatabaseService db, @Description(value="The node representing a geometry to add to the layer") @Parameter(name="node") Node node, @Description(value="The layer to add the node to.") @Parameter(name="layer") String layer) {
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        System.out.println("adding node " + node + " to layer '" + layer + "'");
        EditableLayer spatialLayer = (EditableLayer)spatialService.getLayer(layer);
        Transaction tx = db.beginTx();
        try {
            spatialLayer.add(node);
            tx.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            tx.failure();
        }
        finally {
            tx.finish();
        }
        return this.toArray(node);
    }

    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="add a geometry specified in WKT format to a layer, encoding in the specified layers encoding schemea.")
    public Iterable<Node> addGeometryWKTToLayer(@Source GraphDatabaseService db, @Description(value="The geometry in WKT to add to the layer") @Parameter(name="geometry") String geometryWKT, @Description(value="The layer to add the node to.") @Parameter(name="layer") String layer) {
        System.out.println("Adding geometry to layer '" + layer + "': " + geometryWKT);
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        EditableLayer spatialLayer = (EditableLayer)spatialService.getLayer(layer);
        try {
            WKTReader reader = new WKTReader(spatialLayer.getGeometryFactory());
            Geometry geometry = reader.read(geometryWKT);
            SpatialDatabaseRecord record = spatialLayer.add(geometry);
            return this.toArray(record.getGeomNode());
        }
        catch (ParseException e) {
            System.err.println("Invalid Geometry: " + e.getLocalizedMessage());
            return null;
        }
    }

    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="update an existing geometry specified in WKT format. The layer must already contain the record.")
    public Iterable<Node> updateGeometryFromWKT(@Source GraphDatabaseService db, @Description(value="The geometry in WKT to add to the layer") @Parameter(name="geometry") String geometryWKT, @Description(value="The geometry node id") @Parameter(name="node") long nodeId, @Description(value="The layer to add the node to.") @Parameter(name="layer") String layer) {
        System.out.println("Adding geometry to layer '" + layer + "': " + geometryWKT);
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        EditableLayer spatialLayer = (EditableLayer)spatialService.getLayer(layer);
        try {
            WKTReader reader = new WKTReader(spatialLayer.getGeometryFactory());
            Geometry geometry = reader.read(geometryWKT);
            SpatialDatabaseRecord record = spatialLayer.getIndex().get(nodeId);
            spatialLayer.getGeometryEncoder().encodeGeometry(geometry, (PropertyContainer)record.getGeomNode());
            return this.toArray(record.getGeomNode());
        }
        catch (ParseException e) {
            System.err.println("Invalid Geometry: " + e.getLocalizedMessage());
            return null;
        }
    }

    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="search a layer for geometries in a bounding box. To achieve more complex CQL searches, pre-define the dynamic layer with addCQLDynamicLayer.")
    public Iterable<Node> findGeometriesInBBox(@Source GraphDatabaseService db, @Description(value="The minimum x value of the bounding box") @Parameter(name="minx") double minx, @Description(value="The maximum x value of the bounding box") @Parameter(name="maxx") double maxx, @Description(value="The minimum y value of the bounding box") @Parameter(name="miny") double miny, @Description(value="The maximum y value of the bounding box") @Parameter(name="maxy") double maxy, @Description(value="The layer to search. Can be a dynamic layer with pre-defined CQL filter.") @Parameter(name="layer") String layerName) {
        System.out.println("Finding Geometries in layer '" + layerName + "'");
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        Layer layer = spatialService.getDynamicLayer(layerName);
        if (layer == null) {
            layer = spatialService.getLayer(layerName);
        }
        return GeoPipeline.startWithinSearch(layer, layer.getGeometryFactory().toGeometry(new Envelope(minx, maxx, miny, maxy))).toNodeList();
    }

    @PluginTarget(value=GraphDatabaseService.class)
    @Description(value="search a layer for geometries within a distance of a point. To achieve more complex CQL searches, pre-define the dynamic layer with addCQLDynamicLayer.")
    public Iterable<Node> findGeometriesWithinDistance(@Source GraphDatabaseService db, @Description(value="The x value of a point") @Parameter(name="pointX") double pointX, @Description(value="The y value of a point") @Parameter(name="pointY") double pointY, @Description(value="The distance from the point to search") @Parameter(name="distanceInKm") double distanceInKm, @Description(value="The layer to search. Can be a dynamic layer with pre-defined CQL filter.") @Parameter(name="layer") String layerName) {
        System.out.println("Finding Geometries in layer '" + layerName + "'");
        SpatialDatabaseService spatialService = new SpatialDatabaseService(db);
        Layer layer = spatialService.getDynamicLayer(layerName);
        if (layer == null) {
            layer = spatialService.getLayer(layerName);
        }
        return GeoPipeline.startNearestNeighborLatLonSearch(layer, new Coordinate(pointX, pointY), distanceInKm).sort("OrthodromicDistance").toNodeList();
    }

    private Iterable<Node> toArray(Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (result != null) {
            result.add(node);
        }
        return result;
    }
}

