/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import org.rrd4j.core.RrdByteArrayBackend;

public class RrdMongoDBBackend
extends RrdByteArrayBackend {
    private final DBCollection rrdCollection;
    private volatile boolean dirty = false;

    public RrdMongoDBBackend(String path, DBCollection rrdCollection) {
        super(path);
        this.rrdCollection = rrdCollection;
        BasicDBObject query = new BasicDBObject();
        query.put("path", (Object)path);
        DBObject rrdObject = rrdCollection.findOne((DBObject)query);
        if (rrdObject != null) {
            this.buffer = (byte[])rrdObject.get("rrd");
        }
    }

    protected synchronized void write(long offset, byte[] bytes) throws IOException {
        super.write(offset, bytes);
        this.dirty = true;
    }

    public void close() throws IOException {
        if (this.dirty) {
            BasicDBObject query = new BasicDBObject();
            query.put("path", (Object)this.getPath());
            DBObject rrdObject = this.rrdCollection.findOne((DBObject)query);
            if (rrdObject == null) {
                rrdObject = new BasicDBObject();
                rrdObject.put("path", (Object)this.getPath());
            }
            rrdObject.put("rrd", (Object)this.buffer);
            this.rrdCollection.save(rrdObject);
        }
    }
}

