/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.neo4j;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.MultiIterable;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jElement;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.util.Neo4jEdgeSequence;
import java.util.ArrayList;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class Neo4jVertex
extends Neo4jElement
implements Vertex {
    public Neo4jVertex(Node node, Neo4jGraph graph) {
        super(graph);
        this.rawElement = node;
    }

    public Iterable<Edge> getInEdges(String ... labels) {
        if (labels.length == 0) {
            return new Neo4jEdgeSequence(((Node)this.rawElement).getRelationships(Direction.INCOMING), this.graph);
        }
        if (labels.length == 1) {
            return new Neo4jEdgeSequence(((Node)this.rawElement).getRelationships((RelationshipType)DynamicRelationshipType.withName((String)labels[0]), Direction.INCOMING), this.graph);
        }
        ArrayList edges = new ArrayList();
        for (String label : labels) {
            edges.add(new Neo4jEdgeSequence(((Node)this.rawElement).getRelationships((RelationshipType)DynamicRelationshipType.withName((String)label), Direction.INCOMING), this.graph));
        }
        return new MultiIterable(edges);
    }

    public Iterable<Edge> getOutEdges(String ... labels) {
        if (labels.length == 0) {
            return new Neo4jEdgeSequence(((Node)this.rawElement).getRelationships(Direction.OUTGOING), this.graph);
        }
        if (labels.length == 1) {
            return new Neo4jEdgeSequence(((Node)this.rawElement).getRelationships((RelationshipType)DynamicRelationshipType.withName((String)labels[0]), Direction.OUTGOING), this.graph);
        }
        ArrayList edges = new ArrayList();
        for (String label : labels) {
            edges.add(new Neo4jEdgeSequence(((Node)this.rawElement).getRelationships((RelationshipType)DynamicRelationshipType.withName((String)label), Direction.OUTGOING), this.graph));
        }
        return new MultiIterable(edges);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Neo4jVertex && ((Neo4jVertex)object).getId().equals(this.getId());
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public Node getRawVertex() {
        return (Node)this.rawElement;
    }
}

