/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugin.gremlin;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.server.plugin.gremlin.EngineReplacementDecision;

class CountingEngineReplacementDecision
implements EngineReplacementDecision {
    private final AtomicInteger executionCount = new AtomicInteger();
    private final int maxExecutionCount;

    public CountingEngineReplacementDecision(int maxExecutionCount) {
        this.maxExecutionCount = maxExecutionCount;
    }

    @Override
    public void beforeExecution(String script) {
        this.executionCount.incrementAndGet();
    }

    @Override
    public boolean mustReplaceEngine() {
        if (this.executionCount.get() < this.maxExecutionCount) {
            return false;
        }
        this.executionCount.set(0);
        return true;
    }
}

