/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugin.gremlin;

import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.server.plugin.gremlin.CountingEngineReplacementDecision;
import org.neo4j.server.plugin.gremlin.EngineReplacementDecision;
import org.neo4j.server.plugin.gremlin.GremlinToRepresentationConverter;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.ValueRepresentation;

@Description(value="A server side Gremlin plugin for the Neo4j REST server")
public class GremlinPlugin
extends ServerPlugin {
    private final String g = "g";
    private volatile ScriptEngine engine;
    private final EngineReplacementDecision engineReplacementDecision = new CountingEngineReplacementDecision(500);
    private final GremlinToRepresentationConverter gremlinToRepresentationConverter = new GremlinToRepresentationConverter();

    private ScriptEngine createQueryEngine() {
        return new ScriptEngineManager().getEngineByName("gremlin-groovy");
    }

    @Name(value="execute_script")
    @Description(value="execute a Gremlin script with 'g' set to the Neo4jGraph and 'results' containing the results. Only results of one object type is supported.")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation executeScript(@Source GraphDatabaseService neo4j, @Description(value="The Gremlin script") @Parameter(name="script", optional=false) String script, @Description(value="JSON Map of additional parameters for script variables") @Parameter(name="params", optional=true) Map params) {
        try {
            this.engineReplacementDecision.beforeExecution(script);
            Bindings bindings = this.createBindings(neo4j, params);
            Object result = this.engine().eval(script, bindings);
            return this.gremlinToRepresentationConverter.convert(result);
        }
        catch (ScriptException e) {
            return ValueRepresentation.string((String)e.getMessage());
        }
    }

    private Bindings createBindings(GraphDatabaseService neo4j, Map params) {
        Bindings bindings = this.createInitialBinding(neo4j);
        if (params != null) {
            bindings.putAll(params);
        }
        return bindings;
    }

    private Bindings createInitialBinding(GraphDatabaseService neo4j) {
        SimpleBindings bindings = new SimpleBindings();
        Neo4jGraph graph = new Neo4jGraph(neo4j, false);
        bindings.put("g", (Object)graph);
        return bindings;
    }

    private ScriptEngine engine() {
        if (this.engine == null || this.engineReplacementDecision.mustReplaceEngine()) {
            this.engine = this.createQueryEngine();
        }
        return this.engine;
    }

    public Representation getRepresentation(Object data) {
        return this.gremlinToRepresentationConverter.convert(data);
    }
}

