/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugin.gremlin;

import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jEdge;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jVertex;
import com.tinkerpop.pipes.util.Table;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.DatabaseRepresentation;
import org.neo4j.server.rest.repr.GremlinTableRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class GremlinToRepresentationConverter {
    public Representation convert(Object data) {
        if (data instanceof Table) {
            return new GremlinTableRepresentation((Table)data);
        }
        if (data instanceof Iterable) {
            return this.getListRepresentation((Iterable)data);
        }
        if (data instanceof Iterator) {
            Iterator iterator = (Iterator)data;
            return this.getIteratorRepresentation(iterator);
        }
        return this.getSingleRepresentation(data);
    }

    Representation getIteratorRepresentation(Iterator data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        while (data.hasNext()) {
            Object value = data.next();
            if (value instanceof Iterable) {
                ArrayList<Representation> nested = new ArrayList<Representation>();
                nested.addAll(this.convertValuesToRepresentations((Iterable)value));
                results.add((Representation)new ListRepresentation(this.getType(nested), nested));
            }
            Representation representation = this.getSingleRepresentation(value);
            results.add(representation);
        }
        return new ListRepresentation(this.getType(results), results);
    }

    Representation getListRepresentation(Iterable data) {
        List<Representation> results = this.convertValuesToRepresentations(data);
        return new ListRepresentation(this.getType(results), results);
    }

    List<Representation> convertValuesToRepresentations(Iterable data) {
        ArrayList<Representation> results = new ArrayList<Representation>();
        if (data instanceof Table) {
            results.add((Representation)new GremlinTableRepresentation((Table)data));
        } else {
            for (Object value : data) {
                if (value instanceof Iterable) {
                    ArrayList<Representation> nested = new ArrayList<Representation>();
                    nested.addAll(this.convertValuesToRepresentations((Iterable)value));
                    results.add((Representation)new ListRepresentation(this.getType(nested), nested));
                    continue;
                }
                results.add(this.getSingleRepresentation(value));
            }
        }
        return results;
    }

    RepresentationType getType(List<Representation> representations) {
        if (representations == null || representations.isEmpty()) {
            return RepresentationType.STRING;
        }
        return representations.get(0).getRepresentationType();
    }

    Representation getSingleRepresentation(Object result) {
        if (result == null) {
            return ValueRepresentation.string((String)"null");
        }
        if (result instanceof Neo4jVertex) {
            return new NodeRepresentation(((Neo4jVertex)result).getRawVertex());
        }
        if (result instanceof Neo4jEdge) {
            return new RelationshipRepresentation(((Neo4jEdge)result).getRawEdge());
        }
        if (result instanceof GraphDatabaseService) {
            return new DatabaseRepresentation((GraphDatabaseService)result);
        }
        if (result instanceof Node) {
            return new NodeRepresentation((Node)result);
        }
        if (result instanceof Relationship) {
            return new RelationshipRepresentation((Relationship)result);
        }
        if (result instanceof Neo4jGraph) {
            return ValueRepresentation.string((String)((Neo4jGraph)result).getRawGraph().toString());
        }
        if (result instanceof Double || result instanceof Float) {
            return ValueRepresentation.number((double)((Number)result).doubleValue());
        }
        if (result instanceof Long) {
            return ValueRepresentation.number((long)((Long)result));
        }
        if (result instanceof Integer) {
            return ValueRepresentation.number((int)((Integer)result));
        }
        return ValueRepresentation.string((String)result.toString());
    }
}

