/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geotools.data.TransactionStateDiff;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

public class Diff {
    private final Map<String, SimpleFeature> modifiedFeatures;
    private final Map<String, SimpleFeature> addedFeatures;
    private final List<String> addedFidList;
    public final Map<String, SimpleFeature> modified2;
    public final Map<String, SimpleFeature> added;
    private final List<String> order;
    public int nextFID = 0;
    private SpatialIndex spatialIndex;
    Object mutex;
    public static final SimpleFeature NULL = new SimpleFeature(){

        public Object getAttribute(String path) {
            return null;
        }

        public Object getAttribute(int index) {
            return null;
        }

        public ReferencedEnvelope getBounds() {
            return null;
        }

        public Geometry getDefaultGeometry() {
            return null;
        }

        public SimpleFeatureType getFeatureType() {
            return null;
        }

        public String getID() {
            return null;
        }

        public FeatureId getIdentifier() {
            return null;
        }

        public void setAttribute(int position, Object val) {
        }

        public void setAttribute(String path, Object attribute) throws IllegalAttributeException {
        }

        public Object getAttribute(Name name) {
            return null;
        }

        public int getAttributeCount() {
            return 0;
        }

        public List<Object> getAttributes() {
            return null;
        }

        public SimpleFeatureType getType() {
            return null;
        }

        public void setAttribute(Name name, Object value) {
        }

        public void setAttributes(List<Object> values) {
        }

        public void setAttributes(Object[] values) {
        }

        public void setDefaultGeometry(Object geometry) {
        }

        public GeometryAttribute getDefaultGeometryProperty() {
            return null;
        }

        public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        }

        public Collection<Property> getProperties(Name name) {
            return null;
        }

        public Collection<Property> getProperties() {
            return null;
        }

        public Collection<Property> getProperties(String name) {
            return null;
        }

        public Property getProperty(Name name) {
            return null;
        }

        public Property getProperty(String name) {
            return null;
        }

        public Collection<? extends Property> getValue() {
            return null;
        }

        public void setValue(Collection<Property> values) {
        }

        public AttributeDescriptor getDescriptor() {
            return null;
        }

        public Name getName() {
            return null;
        }

        public Map<Object, Object> getUserData() {
            return null;
        }

        public boolean isNillable() {
            return false;
        }

        public void setValue(Object newValue) {
        }

        public String toString() {
            return "<NullFeature>";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object arg0) {
            return arg0 == this;
        }

        public void validate() {
        }
    };

    public Diff() {
        this.modifiedFeatures = new ConcurrentHashMap<String, SimpleFeature>();
        this.addedFeatures = new ConcurrentHashMap<String, SimpleFeature>();
        this.addedFidList = new CopyOnWriteArrayList<String>();
        this.modified2 = Collections.unmodifiableMap(this.modifiedFeatures);
        this.added = Collections.unmodifiableMap(this.addedFeatures);
        this.order = Collections.unmodifiableList(this.addedFidList);
        this.spatialIndex = new Quadtree();
        this.mutex = this;
    }

    public Diff(Diff other) {
        this.modifiedFeatures = new ConcurrentHashMap<String, SimpleFeature>(other.modifiedFeatures);
        this.addedFeatures = new ConcurrentHashMap<String, SimpleFeature>(other.addedFeatures);
        this.addedFidList = new CopyOnWriteArrayList<String>(other.addedFidList);
        this.modified2 = Collections.unmodifiableMap(this.modifiedFeatures);
        this.added = Collections.unmodifiableMap(this.addedFeatures);
        this.order = Collections.unmodifiableList(this.addedFidList);
        this.spatialIndex = this.copySTRtreeFrom(other);
        this.nextFID = other.nextFID;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.modifiedFeatures.isEmpty() && this.addedFeatures.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.nextFID = 0;
            this.addedFeatures.clear();
            this.addedFidList.clear();
            this.modifiedFeatures.clear();
            this.spatialIndex = new Quadtree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String fid, SimpleFeature f) {
        Object object = this.mutex;
        synchronized (object) {
            SimpleFeature old;
            if (this.addedFeatures.containsKey(fid)) {
                old = this.addedFeatures.get(fid);
                if (f == null) {
                    this.addedFeatures.remove(fid);
                    this.addedFidList.remove(fid);
                } else {
                    this.addedFeatures.put(fid, f);
                }
            } else {
                old = this.modifiedFeatures.get(fid);
                this.modifiedFeatures.put(fid, f);
            }
            if (old != null) {
                this.spatialIndex.remove((Envelope)ReferencedEnvelope.reference(old.getBounds()), (Object)old);
            }
            this.addToSpatialIndex(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String fid, SimpleFeature f) {
        Object object = this.mutex;
        synchronized (object) {
            this.addedFeatures.put(fid, f);
            this.addedFidList.add(fid);
            this.addToSpatialIndex(f);
        }
    }

    protected void addToSpatialIndex(SimpleFeature f) {
        BoundingBox bounds;
        if (f.getDefaultGeometry() != null && !(bounds = f.getBounds()).isEmpty()) {
            this.spatialIndex.insert((Envelope)ReferencedEnvelope.reference(bounds), (Object)f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String fid) {
        Object object = this.mutex;
        synchronized (object) {
            SimpleFeature old = null;
            if (this.addedFeatures.containsKey(fid)) {
                old = this.addedFeatures.get(fid);
                this.addedFeatures.remove(fid);
                this.addedFidList.remove(fid);
            } else {
                old = this.modifiedFeatures.get(fid);
                this.modifiedFeatures.put(fid, TransactionStateDiff.NULL);
            }
            if (old != null) {
                this.spatialIndex.remove((Envelope)ReferencedEnvelope.reference(old.getBounds()), (Object)old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SimpleFeature> queryIndex(Envelope env) {
        Object object = this.mutex;
        synchronized (object) {
            return this.spatialIndex.query(env);
        }
    }

    public List<String> getAddedOrder() {
        return this.addedFidList;
    }

    public Map<String, SimpleFeature> getModified() {
        return this.modified2;
    }

    public Map<String, SimpleFeature> getAdded() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Quadtree copySTRtreeFrom(Diff diff) {
        Quadtree tree = new Quadtree();
        Diff diff2 = diff;
        synchronized (diff2) {
            for (Map.Entry<String, SimpleFeature> e : diff.added.entrySet()) {
                SimpleFeature f = e.getValue();
                if (diff.modifiedFeatures.containsKey(f.getID())) continue;
                tree.insert((Envelope)ReferencedEnvelope.reference(f.getBounds()), (Object)f);
            }
            for (Map.Entry<String, SimpleFeature> e : diff.modified2.entrySet()) {
                SimpleFeature f = e.getValue();
                tree.insert((Envelope)ReferencedEnvelope.reference(f.getBounds()), (Object)f);
            }
        }
        return tree;
    }
}

