/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.FilteredIterator;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class SubFeatureCollection
extends AbstractFeatureCollection {
    protected Filter filter;
    protected SimpleFeatureCollection collection;
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public SubFeatureCollection(SimpleFeatureCollection collection) {
        this(collection, (Filter)Filter.INCLUDE);
    }

    public SubFeatureCollection(SimpleFeatureCollection collection, Filter subfilter) {
        super((SimpleFeatureType)collection.getSchema());
        if (subfilter == null) {
            subfilter = Filter.INCLUDE;
        }
        if (subfilter.equals(Filter.EXCLUDE)) {
            throw new IllegalArgumentException("A subcollection with Filter.EXCLUDE would be empty");
        }
        if (collection instanceof SubFeatureCollection) {
            SubFeatureCollection filtered = (SubFeatureCollection)collection;
            if (subfilter.equals(Filter.INCLUDE)) {
                this.collection = filtered.collection;
                this.filter = filtered.filter();
            } else {
                this.collection = filtered.collection;
                this.filter = this.ff.and(filtered.filter(), subfilter);
            }
        } else {
            this.collection = collection;
            this.filter = subfilter;
        }
    }

    public Iterator openIterator() {
        return new FilteredIterator<SimpleFeature>(this.collection, this.filter());
    }

    public void closeIterator(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        if (iterator instanceof FilteredIterator) {
            FilteredIterator filtered = (FilteredIterator)iterator;
            filtered.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int count = 0;
        Iterator<SimpleFeature> i = null;
        try {
            i = this.iterator();
            while (i.hasNext()) {
                i.next();
                ++count;
            }
        }
        finally {
            this.close(i);
        }
        return count;
    }

    protected Filter filter() {
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
        return this.filter;
    }

    protected Filter createFilter() {
        return Filter.INCLUDE;
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator(this, this.iterator());
    }

    public void close(SimpleFeatureIterator close) {
        if (close != null) {
            close.close();
        }
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter.equals(Filter.INCLUDE)) {
            return this;
        }
        if (filter.equals(Filter.EXCLUDE)) {
            // empty if block
        }
        return new SubFeatureCollection(this, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        Iterator<SimpleFeature> iterator = null;
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                try {
                    SimpleFeature feature = iterator.next();
                    visitor.visit((Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
                float f = position;
                position = f + 1.0f;
                progress.progress(f / size);
            }
        }
        finally {
            progress.complete();
            this.close(iterator);
        }
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return new SubFeatureList(this.collection, this.filter, order);
    }

    @Override
    public boolean add(SimpleFeature o) {
        return this.collection.add(o);
    }

    @Override
    public void clear() {
        List<SimpleFeature> toDelete = DataUtilities.list(this);
        this.removeAll(toDelete);
    }

    @Override
    public boolean remove(Object o) {
        return this.collection.remove(o);
    }

    @Override
    public String getID() {
        return this.collection.getID();
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), this.features());
    }

    public int getCount() throws IOException {
        return this.size();
    }

    public SimpleFeatureCollection collection() throws IOException {
        return this;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        BoundsVisitor bounds = new BoundsVisitor();
        this.accepts(bounds, new NullProgressListener());
        return bounds.getBounds();
    }
}

