/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.tg;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.MultiIterable;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerElement;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.pgm.impls.tg.util.TinkerEdgeSequence;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class TinkerVertex
extends TinkerElement
implements Vertex,
Serializable {
    protected Set<Edge> outEdges = new HashSet<Edge>();
    protected Set<Edge> inEdges = new HashSet<Edge>();

    protected TinkerVertex(String id, TinkerGraph graph) {
        super(id, graph);
    }

    public TinkerVertex getRawVertex() {
        return this;
    }

    @Override
    public Iterable<Edge> getInEdges(String ... labels) {
        if (labels.length == 0) {
            return new LinkedList<Edge>(this.inEdges);
        }
        if (labels.length == 1) {
            return new TinkerEdgeSequence(new LinkedList<Edge>(this.inEdges), labels[0]);
        }
        LinkedList edges = new LinkedList();
        for (String label : labels) {
            edges.add(this.getInEdges(label));
        }
        return new MultiIterable<Edge>(edges);
    }

    @Override
    public Iterable<Edge> getOutEdges(String ... labels) {
        if (labels.length == 0) {
            return new LinkedList<Edge>(this.outEdges);
        }
        if (labels.length == 1) {
            return new TinkerEdgeSequence(new LinkedList<Edge>(this.outEdges), labels[0]);
        }
        LinkedList edges = new LinkedList();
        for (String label : labels) {
            edges.add(this.getOutEdges(label));
        }
        return new MultiIterable<Edge>(edges);
    }

    public String toString() {
        return StringFactory.vertexString(this);
    }

    public boolean equals(Object object) {
        return object instanceof TinkerVertex && ((TinkerVertex)object).getId().equals(this.getId());
    }
}

