/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.json;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Vertex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public final class GraphSONFactory {
    private static JsonNodeFactory jsonNodeFactory = JsonNodeFactory.instance;
    private static ObjectMapper mapper = new ObjectMapper();

    public static JSONObject createJSONElement(Element element) throws JSONException {
        return GraphSONFactory.createJSONElement(element, null, false);
    }

    public static JSONObject createJSONElement(Element element, List<String> propertyKeys, boolean showTypes) throws JSONException {
        ObjectNode objectNode = GraphSONFactory.createJSONElementAsObjectNode(element, propertyKeys, showTypes);
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(new JSONTokener(mapper.writeValueAsString((Object)objectNode)));
        }
        catch (IOException ioe) {
            throw new JSONException((Throwable)ioe);
        }
        return jsonObject;
    }

    public static ObjectNode createJSONElementAsObjectNode(Element element) {
        return GraphSONFactory.createJSONElementAsObjectNode(element, null, false);
    }

    public static ObjectNode createJSONElementAsObjectNode(Element element, List<String> propertyKeys, boolean showTypes) {
        ObjectNode jsonElement = GraphSONFactory.createJSONMap(GraphSONFactory.createPropertyMap(element, propertyKeys), propertyKeys, showTypes);
        GraphSONFactory.putObject(jsonElement, "_id", element.getId());
        if (element instanceof Vertex) {
            jsonElement.put("_type", "vertex");
        } else if (element instanceof Edge) {
            Edge edge = (Edge)element;
            jsonElement.put("_type", "edge");
            GraphSONFactory.putObject(jsonElement, "_outV", edge.getOutVertex().getId());
            GraphSONFactory.putObject(jsonElement, "_inV", edge.getInVertex().getId());
            jsonElement.put("_label", edge.getLabel());
        }
        return jsonElement;
    }

    private static ArrayNode createJSONList(List list, List<String> propertyKeys, boolean showTypes) {
        ArrayNode jsonList = jsonNodeFactory.arrayNode();
        for (Object item : list) {
            if (item instanceof Element) {
                jsonList.add((JsonNode)GraphSONFactory.createJSONElementAsObjectNode((Element)item, propertyKeys, showTypes));
                continue;
            }
            if (item instanceof List) {
                jsonList.add((JsonNode)GraphSONFactory.createJSONList((List)item, propertyKeys, showTypes));
                continue;
            }
            if (item instanceof Map) {
                jsonList.add((JsonNode)GraphSONFactory.createJSONMap((Map)item, propertyKeys, showTypes));
                continue;
            }
            if (item != null && item.getClass().isArray()) {
                jsonList.add((JsonNode)GraphSONFactory.createJSONList(GraphSONFactory.convertArrayToList(item), propertyKeys, showTypes));
                continue;
            }
            GraphSONFactory.addObject(jsonList, item);
        }
        return jsonList;
    }

    private static ObjectNode createJSONMap(Map map, List<String> propertyKeys, boolean showTypes) {
        ObjectNode jsonMap = jsonNodeFactory.objectNode();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value != null) {
                if (value instanceof List) {
                    value = GraphSONFactory.createJSONList((List)value, propertyKeys, showTypes);
                } else if (value instanceof Map) {
                    value = GraphSONFactory.createJSONMap((Map)value, propertyKeys, showTypes);
                } else if (value instanceof Element) {
                    value = GraphSONFactory.createJSONElementAsObjectNode((Element)value, propertyKeys, showTypes);
                } else if (value.getClass().isArray()) {
                    value = GraphSONFactory.createJSONList(GraphSONFactory.convertArrayToList(value), propertyKeys, showTypes);
                }
            }
            GraphSONFactory.putObject(jsonMap, key.toString(), GraphSONFactory.getValue(value, showTypes));
        }
        return jsonMap;
    }

    private static void addObject(ArrayNode jsonList, Object value) {
        if (value == null) {
            jsonList.add((JsonNode)null);
        } else if (value instanceof Boolean) {
            jsonList.add(((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            jsonList.add(((Long)value).longValue());
        } else if (value instanceof Integer) {
            jsonList.add(((Integer)value).intValue());
        } else if (value instanceof Float) {
            jsonList.add(((Float)value).floatValue());
        } else if (value instanceof Double) {
            jsonList.add(((Double)value).doubleValue());
        } else if (value instanceof String) {
            jsonList.add((String)value);
        } else if (value instanceof ObjectNode) {
            jsonList.add((JsonNode)((ObjectNode)value));
        } else if (value instanceof ArrayNode) {
            jsonList.add((JsonNode)((ArrayNode)value));
        } else {
            jsonList.add(value.toString());
        }
    }

    private static void putObject(ObjectNode jsonMap, String key, Object value) {
        if (value == null) {
            jsonMap.put(key, (JsonNode)null);
        } else if (value instanceof Boolean) {
            jsonMap.put(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            jsonMap.put(key, ((Long)value).longValue());
        } else if (value instanceof Integer) {
            jsonMap.put(key, ((Integer)value).intValue());
        } else if (value instanceof Float) {
            jsonMap.put(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            jsonMap.put(key, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            jsonMap.put(key, (String)value);
        } else if (value instanceof ObjectNode) {
            jsonMap.put(key, (JsonNode)((ObjectNode)value));
        } else if (value instanceof ArrayNode) {
            jsonMap.put(key, (JsonNode)((ArrayNode)value));
        } else {
            jsonMap.put(key, value.toString());
        }
    }

    private static Map createPropertyMap(Element element, List<String> propertyKeys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (propertyKeys == null) {
            for (String key : element.getPropertyKeys()) {
                map.put(key, element.getProperty(key));
            }
        } else {
            for (String key : propertyKeys) {
                Object valToPutInMap = element.getProperty(key);
                if (valToPutInMap == null) continue;
                map.put(key, valToPutInMap);
            }
        }
        return map;
    }

    private static Object getValue(Object value, boolean includeType) {
        Object returnValue = value;
        if (includeType) {
            String type = GraphSONFactory.determineType(value);
            ObjectNode valueAndType = jsonNodeFactory.objectNode();
            valueAndType.put("type", type);
            if (type.equals("list")) {
                ArrayNode list = (ArrayNode)value;
                ArrayNode valueArray = valueAndType.putArray("value");
                for (int ix = 0; ix < list.size(); ++ix) {
                    GraphSONFactory.addObject(valueArray, GraphSONFactory.getValue(GraphSONFactory.getTypedValueFromJsonNode(list.get(ix)), includeType));
                }
            } else if (type.equals("map")) {
                ObjectNode convertedMap = jsonNodeFactory.objectNode();
                ObjectNode jsonObject = (ObjectNode)value;
                Iterator keyIterator = jsonObject.getFieldNames();
                while (keyIterator.hasNext()) {
                    Object key = keyIterator.next();
                    convertedMap.put(key.toString(), jsonObject.get(key.toString()));
                }
                valueAndType.put("value", (JsonNode)convertedMap);
            } else {
                GraphSONFactory.putObject(valueAndType, "value", value);
            }
            returnValue = valueAndType;
        }
        return returnValue;
    }

    private static Object getTypedValueFromJsonNode(JsonNode node) {
        Object theValue = null;
        if (node != null && !node.isNull()) {
            theValue = node.isBoolean() ? Boolean.valueOf(node.getBooleanValue()) : (node.isDouble() ? Double.valueOf(node.getDoubleValue()) : (node.isInt() ? Integer.valueOf(node.getIntValue()) : (node.isLong() ? Long.valueOf(node.getLongValue()) : (node.isTextual() ? node.getTextValue() : (node.isArray() ? node : node.getValueAsText())))));
        }
        return theValue;
    }

    private static List convertArrayToList(Object value) {
        List<Object> list = new ArrayList<Number>();
        if (value instanceof int[]) {
            int[] arr = (int[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else if (value instanceof double[]) {
            double[] arr = (double[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else if (value instanceof float[]) {
            float[] arr = (float[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(Float.valueOf(arr[ix]));
            }
        } else if (value instanceof long[]) {
            long[] arr = (long[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else if (value instanceof boolean[]) {
            boolean[] arr = (boolean[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else {
            list = Arrays.asList((Object[])value);
        }
        return list;
    }

    private static String determineType(Object value) {
        String type = "string";
        if (value == null) {
            type = "unknown";
        } else if (value instanceof Double) {
            type = "double";
        } else if (value instanceof Float) {
            type = "float";
        } else if (value instanceof Integer) {
            type = "integer";
        } else if (value instanceof Long) {
            type = "long";
        } else if (value instanceof Boolean) {
            type = "boolean";
        } else if (value instanceof ArrayNode) {
            type = "list";
        } else if (value instanceof ObjectNode) {
            type = "map";
        }
        return type;
    }
}

