/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.json;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.MappingJsonFactory;

public class GraphSONReader {
    private final Graph graph;

    public GraphSONReader(Graph graph) {
        this.graph = graph;
    }

    public void inputGraph(InputStream jsonInputStream) throws IOException {
        GraphSONReader.inputGraph(this.graph, jsonInputStream, 1000);
    }

    public void inputGraph(InputStream jsonInputStream, int bufferSize) throws IOException {
        GraphSONReader.inputGraph(this.graph, jsonInputStream, bufferSize);
    }

    public static void inputGraph(Graph graph, InputStream jsonInputStream) throws IOException {
        GraphSONReader.inputGraph(graph, jsonInputStream, 1000);
    }

    public static void inputGraph(Graph graph, InputStream jsonInputStream, int bufferSize) throws IOException {
        boolean hasEmbeddedTypes = false;
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        JsonParser jp = jsonFactory.createJsonParser(jsonInputStream);
        int previousMaxBufferSize = 0;
        if (graph instanceof TransactionalGraph) {
            previousMaxBufferSize = ((TransactionalGraph)graph).getMaxBufferSize();
            ((TransactionalGraph)graph).setMaxBufferSize(bufferSize);
        }
        HashMap<String, Object> vertexIdMap = new HashMap<String, Object>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            Map<String, Object> props;
            JsonNode node;
            String fieldname;
            String string = fieldname = jp.getCurrentName() == null ? "" : jp.getCurrentName();
            if (fieldname.equals("embeddedTypes")) {
                jp.nextToken();
                hasEmbeddedTypes = jp.getBooleanValue();
                continue;
            }
            if (fieldname.equals("vertices")) {
                jp.nextToken();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    node = jp.readValueAsTree();
                    props = GraphSONReader.readProperties(node, true, hasEmbeddedTypes);
                    String vertexId = node.get("_id").getValueAsText();
                    Vertex v = graph.addVertex(vertexId);
                    vertexIdMap.put(vertexId, v.getId());
                    for (Map.Entry<String, Object> entry : props.entrySet()) {
                        v.setProperty(entry.getKey(), entry.getValue());
                    }
                }
                continue;
            }
            if (!fieldname.equals("edges")) continue;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                node = jp.readValueAsTree();
                props = GraphSONReader.readProperties(node, true, hasEmbeddedTypes);
                String edgeId = node.get("_id").getValueAsText();
                Object inVertexKey = vertexIdMap.get(node.get("_inV").getValueAsText());
                Object outVertexKey = vertexIdMap.get(node.get("_outV").getValueAsText());
                String label = node.get("_label").getValueAsText();
                Vertex inV = graph.getVertex(inVertexKey);
                Vertex outV = graph.getVertex(outVertexKey);
                Edge e = graph.addEdge(edgeId, outV, inV, label);
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    e.setProperty(entry.getKey(), entry.getValue());
                }
            }
        }
        jp.close();
        if (graph instanceof TransactionalGraph) {
            ((TransactionalGraph)graph).setMaxBufferSize(previousMaxBufferSize);
        }
    }

    private static Map<String, Object> readProperties(JsonNode node, boolean ignoreReservedKeys, boolean hasEmbeddedTypes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iterator = node.getFields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (ignoreReservedKeys && (!ignoreReservedKeys || GraphSONReader.isReservedKey((String)entry.getKey()))) continue;
            map.put((String)entry.getKey(), GraphSONReader.readProperty((JsonNode)entry.getValue(), hasEmbeddedTypes));
        }
        return map;
    }

    private static boolean isReservedKey(String key) {
        return key.equals("_id") || key.equals("_type") || key.equals("_label") || key.equals("_outV") || key.equals("_inV");
    }

    private static Object readProperty(JsonNode node, boolean hasEmbeddedTypes) {
        Object propertyValue = hasEmbeddedTypes ? (node.get("type").getValueAsText().equals("unknown") ? null : (node.get("type").getValueAsText().equals("boolean") ? Boolean.valueOf(node.get("value").getBooleanValue()) : (node.get("type").getValueAsText().equals("float") ? Float.valueOf(Float.parseFloat(node.get("value").getValueAsText())) : (node.get("type").getValueAsText().equals("double") ? Double.valueOf(node.get("value").getDoubleValue()) : (node.get("type").getValueAsText().equals("integer") ? Integer.valueOf(node.get("value").getIntValue()) : (node.get("type").getValueAsText().equals("long") ? Long.valueOf(node.get("value").getLongValue()) : (node.get("type").getValueAsText().equals("string") ? node.get("value").getTextValue() : (node.get("type").getValueAsText().equals("list") ? GraphSONReader.readProperties(node.get("value").getElements(), hasEmbeddedTypes) : (node.get("type").getValueAsText().equals("map") ? GraphSONReader.readProperties(node.get("value"), false, hasEmbeddedTypes) : node.getValueAsText()))))))))) : (node.isNull() ? null : (node.isBoolean() ? Boolean.valueOf(node.getBooleanValue()) : (node.isDouble() ? Double.valueOf(node.getDoubleValue()) : (node.isInt() ? Integer.valueOf(node.getIntValue()) : (node.isLong() ? Long.valueOf(node.getLongValue()) : (node.isTextual() ? node.getTextValue() : (node.isArray() ? GraphSONReader.readProperties(node.getElements(), hasEmbeddedTypes) : (node.isObject() ? GraphSONReader.readProperties(node, false, hasEmbeddedTypes) : node.getValueAsText()))))))));
        return propertyValue;
    }

    private static List readProperties(Iterator<JsonNode> listOfNodes, boolean hasEmbeddedTypes) {
        ArrayList<Object> array = new ArrayList<Object>();
        while (listOfNodes.hasNext()) {
            array.add(GraphSONReader.readProperty(listOfNodes.next(), hasEmbeddedTypes));
        }
        return array;
    }
}

