/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerWithEmbeddedWebServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerShutdownLoggingFunctionalTest
extends ExclusiveServerTestBase {
    private NeoServer server;

    @Before
    public void setupServer() throws IOException {
        this.server = ServerHelper.createServer(true);
        ServerHelper.cleanTheDatabase(this.server);
    }

    @After
    public void shutdownTheServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldLogShutdown() throws Exception {
        InMemoryAppender appender = new InMemoryAppender(NeoServerWithEmbeddedWebServer.log);
        this.server.stop();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"INFO: Successfully shutdown database ["));
    }
}

