/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.logging.InMemoryAppender;

public class PropertyFileConfiguratorTest {
    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldLoadItEvenIfNotSpecified() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder().build();
        DatabaseTuningPropertyFileBuilder.builder().inDirectory(emptyPropertyFile.getParentFile()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile);
        Assert.assertNotNull(configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)"25M", configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
    }

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldNotLoadIfAnotherSpecified() throws IOException {
        int unlikelyDefaultMemoryMappedValue = 8351;
        File databaseTuningPropertyFileWeWantToUse = DatabaseTuningPropertyFileBuilder.builder().mappedMemory(unlikelyDefaultMemoryMappedValue).build();
        File emptyPropertyFile = PropertyFileBuilder.builder().withDbTuningPropertyFile(databaseTuningPropertyFileWeWantToUse).build();
        DatabaseTuningPropertyFileBuilder.builder().inDirectory(emptyPropertyFile.getParentFile()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile);
        Assert.assertNotNull(configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)(String.valueOf(unlikelyDefaultMemoryMappedValue) + "M"), configurator.getDatabaseTuningProperties().get("neostore.nodestore.db.mapped_memory"));
    }

    @Test
    public void shouldLogInfoWhenDefaultingToTuningPropertiesFileInTheSameDirectoryAsTheNeoServerPropertiesFile() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder().build();
        File tuningPropertiesFile = DatabaseTuningPropertyFileBuilder.builder().inDirectory(emptyPropertyFile.getParentFile()).build();
        InMemoryAppender appender = new InMemoryAppender(PropertyFileConfigurator.log);
        new PropertyFileConfigurator(emptyPropertyFile);
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)String.format("INFO: No database tuning file explicitly set, defaulting to [%s]", tuningPropertiesFile.getAbsolutePath())));
    }
}

