/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.database.Database;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;

public class DatabaseTest {
    private File databaseDirectory;
    private Database theDatabase;
    private boolean deletionFailureOk;

    @Before
    public void setup() throws Exception {
        this.databaseDirectory = ServerTestUtils.createTempDir();
        this.theDatabase = new Database(ServerTestUtils.EMBEDDED_GRAPH_DATABASE_FACTORY, this.databaseDirectory.getAbsolutePath());
    }

    @After
    public void shutdownDatabase() throws IOException {
        block2: {
            this.theDatabase.shutdown();
            try {
                FileUtils.forceDelete((File)this.databaseDirectory);
            }
            catch (IOException e) {
                if (this.deletionFailureOk) break block2;
                throw e;
            }
        }
    }

    @Test
    public void shouldLogOnSuccessfulStartup() {
        InMemoryAppender appender = new InMemoryAppender(Database.log);
        this.theDatabase.startup();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"Successfully started database"));
    }

    @Test
    public void shouldShutdownCleanly() {
        InMemoryAppender appender = new InMemoryAppender(Database.log);
        this.theDatabase.startup();
        this.theDatabase.shutdown();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"Successfully shutdown database"));
    }

    @Test(expected=TransactionFailureException.class)
    public void shouldComplainIfDatabaseLocationIsAlreadyInUse() {
        this.deletionFailureOk = true;
        new Database(ServerTestUtils.EMBEDDED_GRAPH_DATABASE_FACTORY, this.theDatabase.getLocation());
    }

    @Test
    public void connectWithShellOnDefaultPortWhenNoShellConfigSupplied() throws Exception {
        ShellLobby.newClient().shutdown();
    }

    @Test
    public void shouldBeAbleToOverrideShellConfig() throws Exception {
        int customPort = this.findFreeShellPortToUse(8881);
        File tempDir = ServerTestUtils.createTempDir();
        Database otherDb = new Database(ServerTestUtils.EMBEDDED_GRAPH_DATABASE_FACTORY, tempDir.getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"enable_remote_shell", "port=" + customPort}));
        otherDb.startup();
        ShellLobby.newClient((int)customPort).shutdown();
        otherDb.shutdown();
        FileUtils.forceDelete((File)tempDir);
    }

    private int findFreeShellPortToUse(int startingPort) {
        try {
            while (true) {
                ShellLobby.newClient((int)startingPort).shutdown();
                ++startingPort;
            }
        }
        catch (ShellException e) {
            return startingPort;
        }
    }
}

