/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Map;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.database.DatabaseBlockedException;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;

public class AutoIndexFunctionalTest
extends AbstractRestFunctionalTestBase {
    @Documented(value=" Find node by query from an automatic index.\n \n See Find node by query for the actual query syntax.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void shouldRetrieveFromAutoIndexByQuery() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.nodeAutoIndexUri() + "?query=name:I").entity());
    }

    private String nodeAutoIndexUri() {
        return this.getDataUri() + "index/auto/node/";
    }

    @Documented(value=" Automatic index nodes can be found via exact lookups with normal Index\n REST syntax.\n")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void find_node_by_exact_match_from_an_automatic_index() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.nodeAutoIndexUri() + "name/I").entity());
    }

    @Test
    @Documented(value="Documentation not available")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void Relationship_AutoIndex_is_not_removable() throws DatabaseBlockedException, JsonParseException {
        this.data.get();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.relationshipAutoIndexUri()).entity();
    }

    @Test
    @Documented(value="Documentation not available")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void AutoIndex_is_not_removable() throws DatabaseBlockedException, JsonParseException {
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.nodeAutoIndexUri()).entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    @Documented(value="Documentation not available")
    public void items_can_not_be_added_manually_to_an_AutoIndex() throws Exception {
        this.data.get();
        String indexName = this.graphdb().index().getNodeAutoIndexer().getAutoIndex().getName();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).payload(this.createJsonStringFor(this.getNodeUri((Node)((Map)this.data.get()).get("I")), "name", "I")).post(this.postNodeIndexUri(indexName)).entity();
    }

    private String createJsonStringFor(String targetUri, String key, String value) {
        return "{\"key\": \"" + key + "\", \"value\": \"" + value + "\", \"uri\": \"" + targetUri + "\"}";
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    @Documented(value="Documentation not available")
    public void items_can_not_be_added_manually_to_a_Relationship_AutoIndex() throws Exception {
        this.data.get();
        String indexName = this.graphdb().index().getRelationshipAutoIndexer().getAutoIndex().getName();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).payload(this.createJsonStringFor(this.getRelationshipUri((Relationship)((Node)((Map)this.data.get()).get("I")).getRelationships().iterator().next()), "name", "I")).post(this.postRelationshipIndexUri(indexName)).entity();
    }

    @Test
    @Documented(value="Documentation not available")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true)}, autoIndexNodes=true)
    public void autoindexed_items_cannot_be_removed_manually() throws DatabaseBlockedException, JsonParseException {
        long id = ((Node)((Map)this.data.get()).get("I")).getId();
        String indexName = this.graphdb().index().getNodeAutoIndexer().getAutoIndex().getName();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.getDataUri() + "index/node/" + indexName + "/name/I/" + id).entity();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.getDataUri() + "index/node/" + indexName + "/name/" + id).entity();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.getDataUri() + "index/node/" + indexName + "/" + id).entity();
    }

    @Test
    @Documented(value="Documentation not available")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    public void autoindexed_relationships_cannot_be_removed_manually() throws DatabaseBlockedException, JsonParseException {
        long id = ((Relationship)((Node)((Map)this.data.get()).get("I")).getRelationships().iterator().next()).getId();
        String indexName = this.graphdb().index().getRelationshipAutoIndexer().getAutoIndex().getName();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.getDataUri() + "index/relationship/" + indexName + "/since/today/" + id).entity();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.getDataUri() + "index/relationship/" + indexName + "/since/" + id).entity();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(405).delete(this.getDataUri() + "index/relationship/" + indexName + "/" + id).entity();
    }

    @Documented(value="Documentation not available")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    public void Find_relationship_by_query_from_an_automatic_index() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.relationshipAutoIndexUri() + "?query=since:today").entity());
    }

    @Documented(value="Documentation not available")
    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I"), @GraphDescription.NODE(name="you")}, relationships={@GraphDescription.REL(start="I", end="you", type="know", properties={@GraphDescription.PROP(key="since", value="today")})}, autoIndexRelationships=true)
    public void Find_relationship_by_exact_match_from_an_automatic_index() throws PropertyValueException {
        this.data.get();
        this.assertSize(1, ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(this.relationshipAutoIndexUri() + "since/today/").entity());
    }

    private String relationshipAutoIndexUri() {
        return this.getDataUri() + "index/auto/relationship/";
    }
}

