/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class CypherFunctionalTest
extends AbstractRestFunctionalTestBase {
    @Test
    @Documented(value=" A simple query returning all nodes connected to node 1, returning the\n node and the name property, if it exists, otherwise `null`:\n")
    @TestData.Title(value="Send a Query")
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true), @GraphDescription.NODE(name="you", setNameProperty=true), @GraphDescription.NODE(name="him", setNameProperty=true, properties={@GraphDescription.PROP(key="age", value="25", type=GraphDescription.PropType.INTEGER)})}, relationships={@GraphDescription.REL(start="I", end="him", type="know", properties={}), @GraphDescription.REL(start="I", end="you", type="know", properties={})})
    public void testPropertyColumn() throws UnsupportedEncodingException {
        String script = this.createScript("start x  = node(%I%) match x -[r]-> n return type(r), n.name?, n.age?");
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"you"));
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"him"));
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"25"));
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.not((Matcher)JUnitMatchers.containsString((String)"\"x\"")));
    }

    @Test
    @Documented(value=" Errors on the server will be reported as a JSON-formatted stacktrace and\n message.\n")
    @TestData.Title(value="Server errors")
    @GraphDescription.Graph(value={"I know you"})
    public void error_gets_returned_as_json() throws Exception {
        String response = this.cypherRestCall("start x = node(%I%) return x.dummy", Response.Status.BAD_REQUEST, new Pair[0]);
        Assert.assertEquals((long)3L, (long)JsonHelper.jsonToMap((String)response).size());
    }

    @Test
    @Documented(value=" Paths can be returned\n together with other return types by just\n specifying returns.\n")
    @GraphDescription.Graph(value={"I know you"})
    public void return_paths() throws Exception {
        String script = "start x  = node(%I%) match path = (x--friend) return path, friend.name";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Assert.assertEquals((long)2L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"data"));
        Assert.assertThat((Object)response, (Matcher)JUnitMatchers.containsString((String)"you"));
    }

    @Test
    @Documented(value=" Cypher supports queries with parameters\n which are submitted as a JSON map.\n")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_parameters() throws Exception {
        this.data.get();
        String script = "start x  = node:node_auto_index(name={startName}) match path = (x-[r]-friend) where friend.name = {name} return TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.OK, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Assert.assertEquals((long)2L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertTrue((boolean)response.contains("know"));
        Assert.assertTrue((boolean)response.contains("data"));
    }

    @Test
    @Documented(value="Documentation not available")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_syntax_errors() throws Exception {
        this.data.get();
        String script = "start x  = node:node_auto_index(name={startName}) matc path = (x-[r]-friend) where friend.name = {name} return TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.BAD_REQUEST, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Assert.assertEquals((long)3L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertTrue((boolean)response.contains("message"));
    }

    @Test
    @Documented(value=" When sending queries that\n return nested results like list and maps,\n these will get serialized into nested JSON representations\n according to their types.\n")
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void nested_results() throws Exception {
        this.data.get();
        String script = "start n = node(%I%,%you%) return collect(n.name), collect(n)";
        String response = this.cypherRestCall(script, Response.Status.OK, new Pair[0]);
        Map resultMap = JsonHelper.jsonToMap((String)response);
        Assert.assertEquals((long)2L, (long)resultMap.size());
        Assert.assertTrue((boolean)response.contains("[ [ [ \"I\""));
    }

    @Test
    @Documented(value="Documentation not available")
    @Ignore
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void send_queries_with_errors() throws Exception {
        this.data.get();
        String script = "start x  = node:node_auto_index(name={startName}) match path = (x-[r]-friend) where frien.name = {name} return TYPE(r)";
        String response = this.cypherRestCall(script, Response.Status.BAD_REQUEST, Pair.of((Object)"startName", (Object)"I"), Pair.of((Object)"name", (Object)"you"));
        Assert.assertEquals((long)3L, (long)JsonHelper.jsonToMap((String)response).size());
        Assert.assertTrue((boolean)response.contains("message"));
    }

    private String cypherRestCall(String script, Response.Status status, Pair<String, String> ... params) {
        return super.doCypherRestCall(this.cypherUri(), script, status, params);
    }

    private String cypherUri() {
        return this.getDataUri() + "cypher";
    }
}

