/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;

public class RestRequest {
    private final URI baseUri;
    private static final Client DEFAULT_CLIENT = Client.create();
    private final Client client;

    public RestRequest(URI baseUri) {
        this(baseUri, null, null);
    }

    public RestRequest(URI baseUri, String username, String password) {
        this.baseUri = this.uriWithoutSlash(baseUri);
        if (username != null) {
            this.client = Client.create();
            this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        } else {
            this.client = DEFAULT_CLIENT;
        }
    }

    public RestRequest(URI uri, Client client) {
        this.baseUri = this.uriWithoutSlash(uri);
        this.client = client;
    }

    public RestRequest() {
        this(null);
    }

    private URI uriWithoutSlash(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriString = uri.toString();
        return uriString.endsWith("/") ? this.uri(uriString.substring(0, uriString.length() - 1)) : uri;
    }

    public static String encode(Object value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value.toString(), "utf-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private WebResource.Builder builder(String path) {
        return this.builder(path, MediaType.APPLICATION_JSON_TYPE);
    }

    private WebResource.Builder builder(String path, MediaType accept) {
        WebResource resource = this.client.resource(this.uri(this.pathOrAbsolute(path)));
        return resource.accept(new MediaType[]{accept});
    }

    private String pathOrAbsolute(String path) {
        if (path.startsWith("http://")) {
            return path;
        }
        return this.baseUri + "/" + path;
    }

    public JaxRsResponse get(String path) {
        return JaxRsResponse.extractFrom((ClientResponse)this.builder(path).get(ClientResponse.class));
    }

    public JaxRsResponse get(String path, String data) {
        return this.get(path, data, MediaType.APPLICATION_JSON_TYPE);
    }

    public JaxRsResponse get(String path, String data, MediaType mediaType) {
        WebResource.Builder builder = this.builder(path);
        builder = data != null ? (WebResource.Builder)builder.entity((Object)data, mediaType) : (WebResource.Builder)builder.type(mediaType);
        return JaxRsResponse.extractFrom((ClientResponse)builder.get(ClientResponse.class));
    }

    public JaxRsResponse delete(String path) {
        return JaxRsResponse.extractFrom((ClientResponse)this.builder(path).delete(ClientResponse.class));
    }

    public JaxRsResponse post(String path, String data) {
        return this.post(path, data, MediaType.APPLICATION_JSON_TYPE);
    }

    public JaxRsResponse post(String path, String data, MediaType mediaType) {
        WebResource.Builder builder = this.builder(path);
        builder = data != null ? (WebResource.Builder)builder.entity((Object)data, mediaType) : (WebResource.Builder)builder.type(mediaType);
        return JaxRsResponse.extractFrom((ClientResponse)builder.post(ClientResponse.class));
    }

    public JaxRsResponse put(String path, String data) {
        WebResource.Builder builder = this.builder(path);
        if (data != null) {
            builder = (WebResource.Builder)builder.entity((Object)data, MediaType.APPLICATION_JSON_TYPE);
        }
        return new JaxRsResponse((ClientResponse)builder.put(ClientResponse.class));
    }

    public Object toEntity(JaxRsResponse JaxRsResponse2) throws PropertyValueException {
        return JsonHelper.jsonToSingleValue((String)this.entityString(JaxRsResponse2));
    }

    public Map<?, ?> toMap(JaxRsResponse JaxRsResponse2) throws JsonParseException {
        String json = this.entityString(JaxRsResponse2);
        return JsonHelper.jsonToMap((String)json);
    }

    private String entityString(JaxRsResponse JaxRsResponse2) {
        return JaxRsResponse2.getEntity();
    }

    public boolean statusIs(JaxRsResponse JaxRsResponse2, Response.StatusType status) {
        return JaxRsResponse2.getStatus() == status.getStatusCode();
    }

    public boolean statusOtherThan(JaxRsResponse JaxRsResponse2, Response.StatusType status) {
        return !this.statusIs(JaxRsResponse2, status);
    }

    public RestRequest with(String uri) {
        return new RestRequest(this.uri(uri), this.client);
    }

    private URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getUri() {
        return this.baseUri;
    }

    public JaxRsResponse get() {
        return this.get("");
    }

    public JaxRsResponse get(String path, MediaType acceptType) {
        WebResource.Builder builder = this.builder(path, acceptType);
        return JaxRsResponse.extractFrom((ClientResponse)builder.get(ClientResponse.class));
    }

    public static RestRequest req() {
        return new RestRequest();
    }

    public JaxRsResponse delete(URI location) {
        return this.delete(location.toString());
    }

    public JaxRsResponse put(URI uri, String data) {
        return this.put(uri.toString(), data);
    }
}

