/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.paging.Clock;
import org.neo4j.server.rest.paging.FakeClock;
import org.neo4j.server.rest.paging.Lease;
import org.neo4j.server.rest.paging.LeaseAlreadyExpiredException;
import org.neo4j.server.rest.paging.PagedTraverser;

public class LeaseTest {
    private static final long SIXTY_SECONDS = 60L;
    private static final long THIRTY_SECONDS = 30L;

    /*
     * Exception decompiling
     */
    @Test
    public void shouldReturnHexIdentifierString() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test(expected=LeaseAlreadyExpiredException.class)
    public void shouldNotAllowLeasesInThePast() throws Exception {
        FakeClock clock = new FakeClock();
        new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), this.oneMinuteInThePast(), (Clock)clock);
    }

    private long oneMinuteInThePast() {
        return -60L;
    }

    @Test
    public void leasesShouldExpire() throws Exception {
        FakeClock clock = new FakeClock();
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)clock);
        clock.forwardMinutes(10);
        Assert.assertTrue((boolean)lease.expired());
    }

    @Test
    public void shouldRenewLeaseForSamePeriod() {
        FakeClock clock = new FakeClock();
        Lease lease = new Lease((PagedTraverser)Mockito.mock(PagedTraverser.class), 60L, (Clock)clock);
        clock.forwardSeconds(30L);
        lease.getLeasedItemAndRenewLease();
        clock.forwardSeconds(30L);
        Assert.assertFalse((boolean)lease.expired());
        clock.forwardMinutes(10);
        Assert.assertTrue((boolean)lease.expired());
    }
}

