/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.storemigration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.server.storemigration.PreStartupStoreUpgrader;

public class PreStartupStoreUpgraderTest {
    public static final String HOME_DIRECTORY = "target/" + PreStartupStoreUpgraderTest.class.getSimpleName();
    public static final String STORE_DIRECTORY = HOME_DIRECTORY + "/data/graph.db";

    @Test
    public void shouldExitImmediatelyIfStoreIsAlreadyAtLatestVersion() throws IOException {
        Properties systemProperties = this.buildProperties(false);
        new EmbeddedGraphDatabase(STORE_DIRECTORY).shutdown();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PreStartupStoreUpgrader upgrader = new PreStartupStoreUpgrader(systemProperties, new PrintStream(outputStream));
        int exit = upgrader.run();
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"", (Object)new String(outputStream.toByteArray()));
    }

    @Test
    public void shouldGiveHelpfulMessageIfAutoUpgradeParameterNotSet() throws IOException {
        Properties systemProperties = this.buildProperties(false);
        PreStartupStoreUpgraderTest.prepareSampleLegacyDatabase(new File(STORE_DIRECTORY));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PreStartupStoreUpgrader upgrader = new PreStartupStoreUpgrader(systemProperties, new PrintStream(outputStream));
        int exit = upgrader.run();
        Assert.assertEquals((long)1L, (long)exit);
        String[] lines = new String(outputStream.toByteArray()).split("\\r?\\n");
        Assert.assertTrue((boolean)lines[0].contains("To enable automatic upgrade, please set configuration parameter \"allow_store_upgrade=true\""));
    }

    @Test
    public void shouldExitCleanlyIfDatabaseMissingSoThatDatabaseCreationIsLeftToMainProcess() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PreStartupStoreUpgrader upgrader = new PreStartupStoreUpgrader(this.buildProperties(true), new PrintStream(outputStream));
        int exit = upgrader.run();
        Assert.assertEquals((long)0L, (long)exit);
        Assert.assertEquals((Object)"", (Object)new String(outputStream.toByteArray()));
    }

    @Test
    public void shouldUpgradeDatabase() throws IOException {
        Properties systemProperties = this.buildProperties(true);
        PreStartupStoreUpgraderTest.prepareSampleLegacyDatabase(new File(STORE_DIRECTORY));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PreStartupStoreUpgrader upgrader = new PreStartupStoreUpgrader(systemProperties, new PrintStream(outputStream));
        int exit = upgrader.run();
        Assert.assertEquals((long)0L, (long)exit);
        String[] lines = new String(outputStream.toByteArray()).split("\\r?\\n");
        Assert.assertEquals((Object)"Starting upgrade of database store files", (Object)lines[0]);
        Assert.assertEquals((Object)this.dots(100), (Object)lines[1]);
        Assert.assertEquals((Object)"Finished upgrade of database store files", (Object)lines[2]);
    }

    private Properties buildProperties(boolean allowStoreUpgrade) throws IOException {
        FileUtils.deleteRecursively((File)new File(HOME_DIRECTORY));
        new File(HOME_DIRECTORY + "/conf").mkdirs();
        Properties databaseProperties = new Properties();
        if (allowStoreUpgrade) {
            databaseProperties.setProperty("allow_store_upgrade", "true");
        }
        String databasePropertiesFileName = HOME_DIRECTORY + "/conf/neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        Properties serverProperties = new Properties();
        serverProperties.setProperty("org.neo4j.server.database.location", STORE_DIRECTORY);
        serverProperties.setProperty("org.neo4j.server.db.tuning.properties", databasePropertiesFileName);
        String serverPropertiesFileName = HOME_DIRECTORY + "/conf/neo4j-server.properties";
        serverProperties.store(new FileWriter(serverPropertiesFileName), null);
        Properties systemProperties = new Properties();
        systemProperties.put("org.neo4j.server.properties", serverPropertiesFileName);
        return systemProperties;
    }

    public static void prepareSampleLegacyDatabase(File workingDirectory) throws IOException {
        File resourceDirectory = PreStartupStoreUpgraderTest.findOldFormatStoreDirectory();
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
    }

    public static File findOldFormatStoreDirectory() {
        URL legacyStoreResource = PreStartupStoreUpgraderTest.class.getResource("legacystore/exampledb/neostore");
        return new File(legacyStoreResource.getFile()).getParentFile();
    }

    private String dots(int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(".");
        }
        return builder.toString();
    }
}

