/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webdriver;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.server.webdriver.BrowserTitleIs;
import org.neo4j.server.webdriver.BrowserUrlIs;
import org.neo4j.server.webdriver.Condition;
import org.neo4j.server.webdriver.ElementReference;
import org.neo4j.server.webdriver.ElementVisible;
import org.neo4j.server.webdriver.WebDriverFacade;
import org.neo4j.server.webdriver.WebdriverCondition;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class WebdriverLibrary {
    protected final WebDriver d;

    public WebdriverLibrary(WebDriverFacade df) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        this.d = df.getWebDriver();
    }

    public WebDriver getWebDriver() {
        return this.d;
    }

    public void clickOn(String contains) {
        this.clickOnByXpath("//*[contains(.,'" + contains + "')]");
    }

    public void clickOn(By by) {
        this.getElement(by).click();
    }

    public void clickOnButton(String text) {
        this.clickOnByXpath("//div[contains(.,'" + text + "') and contains(@class, 'button')]");
    }

    public void clickOnLink(String text) {
        this.clickOnByXpath("//a[contains(.,'" + text + "')]");
    }

    public void clickOnByXpath(String xpath) {
        this.clickOn(By.xpath((String)xpath));
    }

    public void waitForUrlToBe(String url) {
        this.waitUntil((Matcher<WebDriver>)BrowserUrlIs.browserUrlIs(url), "Url did not change to expected value within a reasonable time.");
    }

    public void waitForTitleToBe(String title) {
        this.waitUntil((Matcher<WebDriver>)BrowserTitleIs.browserTitleIs(title), "Title did not change to expected value within a reasonable time.");
    }

    public void waitForElementToAppear(By by) {
        this.waitUntil((Matcher<WebDriver>)ElementVisible.elementVisible(by), "Element (" + by.toString() + ") did not appear within a reasonable time.");
    }

    public void waitForElementToDisappear(By by) {
        this.waitUntil((Matcher<WebDriver>)Matchers.not((Matcher)ElementVisible.elementVisible(by)), "Element did not disappear within a reasonable time.");
    }

    public void clearInput(ElementReference el) {
        int len = el.getValue().length();
        Object[] backspaces = new CharSequence[len];
        Arrays.fill(backspaces, Keys.BACK_SPACE);
        el.sendKeys((CharSequence[])backspaces);
    }

    public void waitUntil(Matcher<WebDriver> matcher, String errorMessage) {
        this.waitUntil(matcher, errorMessage, 10000L);
    }

    public void waitUntil(Matcher<WebDriver> matcher, String errorMessage, long timeout) {
        try {
            WebdriverCondition<WebDriver> cond = new WebdriverCondition<WebDriver>(this.getWebDriver(), matcher, this.d);
            ((Condition)cond).waitUntilFulfilled(timeout, errorMessage);
        }
        catch (TimeoutException e) {
            Assert.fail((String)errorMessage);
        }
    }

    public ElementReference getElement(By by) {
        return new ElementReference(this, by);
    }

    public WebElement getWebElement(By by) {
        this.waitForElementToAppear(by);
        return this.d.findElement(by);
    }

    public void refresh() {
        this.d.get(this.d.getCurrentUrl());
    }

    static class ElementClickable
    extends BaseMatcher<ElementReference> {
        ElementClickable() {
        }

        public boolean matches(Object item) {
            try {
                ((ElementReference)item).click();
                return true;
            }
            catch (WebDriverException webDriverException) {
                if (webDriverException.getMessage().contains("Element is not clickable")) {
                    return false;
                }
                throw webDriverException;
            }
        }

        public void describeTo(Description description) {
            description.appendText("Should be clickable");
        }
    }
}

