/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class MathTransformParser
extends AbstractParser {
    protected final MathTransformFactory mtFactory;
    private String classification;
    private OperationMethod lastMethod;

    public MathTransformParser() {
        this(Symbols.DEFAULT);
    }

    public MathTransformParser(Symbols symbols) {
        this(symbols, ReferencingFactoryFinder.getMathTransformFactory(null));
    }

    public MathTransformParser(Symbols symbols, MathTransformFactory mtFactory) {
        super(symbols);
        this.mtFactory = mtFactory;
    }

    public MathTransform parseMathTransform(String text) throws ParseException {
        Element element = this.getTree(text, new ParsePosition(0));
        MathTransform mt = this.parseMathTransform(element, true);
        element.close();
        return mt;
    }

    @Override
    protected Object parse(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean required) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        Object key = element.peek();
        if (key instanceof Element) {
            String keyword = ((Element)key).keyword.trim().toUpperCase(this.symbols.locale);
            if ("PARAM_MT".equals(keyword)) {
                return this.parseParamMT(element);
            }
            if ("CONCAT_MT".equals(keyword)) {
                return this.parseConcatMT(element);
            }
            if ("INVERSE_MT".equals(keyword)) {
                return this.parseInverseMT(element);
            }
            if ("PASSTHROUGH_MT".equals(keyword)) {
                return this.parsePassThroughMT(element);
            }
        }
        if (required) {
            throw element.parseFailed(null, Errors.format((int)187, (Object)key));
        }
        return null;
    }

    private MathTransform parseParamMT(Element parent) throws ParseException {
        MathTransform transform;
        Element param;
        ParameterValueGroup parameters;
        Element element = parent.pullElement("PARAM_MT");
        this.classification = element.pullString("classification");
        try {
            parameters = this.mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
        while ((param = element.pullOptionalElement("PARAMETER")) != null) {
            String name = param.pullString("name");
            ParameterValue parameter = parameters.parameter(name);
            Class type = parameter.getDescriptor().getValueClass();
            if (Integer.class.equals((Object)type)) {
                parameter.setValue(param.pullInteger("value"));
            } else if (Double.class.equals((Object)type)) {
                parameter.setValue(param.pullDouble("value"));
            } else {
                parameter.setValue((Object)param.pullString("value"));
            }
            param.close();
        }
        element.close();
        try {
            transform = this.mtFactory.createParameterizedTransform(parameters);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
        this.lastMethod = this.mtFactory.getLastMethodUsed();
        return transform;
    }

    private MathTransform parseInverseMT(Element parent) throws ParseException {
        Element element = parent.pullElement("INVERSE_MT");
        try {
            MathTransform transform = this.parseMathTransform(element, true).inverse();
            element.close();
            return transform;
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
    }

    private MathTransform parsePassThroughMT(Element parent) throws ParseException {
        Element element = parent.pullElement("PASSTHROUGH_MT");
        int firstAffectedOrdinate = parent.pullInteger("firstAffectedOrdinate");
        MathTransform transform = this.parseMathTransform(element, true);
        element.close();
        try {
            return this.mtFactory.createPassThroughTransform(firstAffectedOrdinate, transform, 0);
        }
        catch (FactoryException exception) {
            throw element.parseFailed((Exception)((Object)exception), null);
        }
    }

    private MathTransform parseConcatMT(Element parent) throws ParseException {
        MathTransform optionalTransform;
        Element element = parent.pullElement("CONCAT_MT");
        MathTransform transform = this.parseMathTransform(element, true);
        while ((optionalTransform = this.parseMathTransform(element, false)) != null) {
            try {
                transform = this.mtFactory.createConcatenatedTransform(transform, optionalTransform);
            }
            catch (FactoryException exception) {
                throw element.parseFailed((Exception)((Object)exception), null);
            }
        }
        element.close();
        return transform;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            for (OperationMethod method : this.mtFactory.getAvailableMethods(Operation.class)) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)method, this.classification)) continue;
                this.lastMethod = method;
                break;
            }
        }
        return this.lastMethod;
    }
}

