/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.TabCompletion;
import org.neo4j.shell.impl.RmiLocation;

public abstract class AbstractServer
extends UnicastRemoteObject
implements ShellServer {
    public static final String DEFAULT_NAME = "shell";
    public static final int DEFAULT_PORT = 1337;
    private Map<String, Serializable> properties = new HashMap<String, Serializable>();

    @Override
    public String getName() {
        return DEFAULT_NAME;
    }

    @Override
    public Serializable getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Serializable value) {
        this.properties.put(key, value);
    }

    @Override
    public Serializable interpretVariable(String key, Serializable value, Session session) throws ShellException, RemoteException {
        return session.get(key);
    }

    @Override
    public String welcome() {
        return "Welcome to the shell";
    }

    @Override
    public void shutdown() {
        try {
            AbstractServer.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Override
    public void makeRemotelyAvailable(int port, String name) throws RemoteException {
        RmiLocation location = RmiLocation.location("localhost", port, name);
        location.bind(this);
    }

    @Override
    public String[] getAllAvailableCommands() {
        return new String[0];
    }

    @Override
    public TabCompletion tabComplete(String partOfLine, Session session) throws ShellException, RemoteException {
        return new TabCompletion(Collections.<String>emptyList(), 0);
    }
}

