/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shell.Session;

public class SessionImpl
implements Session {
    private static final long serialVersionUID = 1L;
    private final Map<String, Serializable> properties = new HashMap<String, Serializable>();
    final SessionWriter writer;

    public SessionImpl() {
        SessionWriterImpl writerImpl;
        try {
            writerImpl = new SessionWriterImpl(this.properties);
        }
        catch (RemoteException e) {
            writerImpl = null;
        }
        this.writer = writerImpl;
    }

    @Override
    public void set(String key, Serializable value) {
        try {
            if (this.writer != null) {
                this.writer.set(key, value);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        SessionImpl.setProperty(this.properties, key, value);
    }

    private static void setProperty(Map<String, Serializable> properties, String key, Serializable value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    @Override
    public Serializable get(String key) {
        return this.properties.get(key);
    }

    @Override
    public Serializable remove(String key) {
        return this.properties.remove(key);
    }

    @Override
    public String[] keys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public Map<String, Serializable> asMap() {
        return new HashMap<String, Serializable>(this.properties);
    }

    private static class SessionWriterImpl
    extends UnicastRemoteObject
    implements SessionWriter {
        private static final long serialVersionUID = 1L;
        private final Map<String, Serializable> properties;

        SessionWriterImpl(Map<String, Serializable> properties) throws RemoteException {
            this.properties = properties;
        }

        @Override
        public void set(String key, Serializable value) {
            SessionImpl.setProperty(this.properties, key, value);
        }
    }

    static interface SessionWriter
    extends Remote {
        public void set(String var1, Serializable var2) throws RemoteException;
    }
}

