/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.util.ArrayList;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.shell.kernel.apps.TypedId;

public abstract class NodeOrRelationship {
    public static final String TYPE_NODE = "n";
    public static final String TYPE_RELATIONSHIP = "r";
    private Object nodeOrRelationship;

    public static NodeOrRelationship wrap(Node node) {
        return new WrapNode(node);
    }

    public static NodeOrRelationship wrap(Relationship rel) {
        return new WrapRelationship(rel);
    }

    public static NodeOrRelationship wrap(PropertyContainer entity) {
        return entity instanceof Node ? NodeOrRelationship.wrap((Node)entity) : NodeOrRelationship.wrap((Relationship)entity);
    }

    private NodeOrRelationship(Object nodeOrRelationship) {
        this.nodeOrRelationship = nodeOrRelationship;
    }

    public boolean isNode() {
        return this.nodeOrRelationship instanceof Node;
    }

    public Node asNode() {
        return (Node)this.nodeOrRelationship;
    }

    public boolean isRelationship() {
        return this.nodeOrRelationship instanceof Relationship;
    }

    public Relationship asRelationship() {
        return (Relationship)this.nodeOrRelationship;
    }

    public PropertyContainer asPropertyContainer() {
        return (PropertyContainer)this.nodeOrRelationship;
    }

    public TypedId getTypedId() {
        return new TypedId(this.getType(), this.getId());
    }

    abstract String getType();

    public abstract long getId();

    public abstract boolean hasProperty(String var1);

    public abstract Object getProperty(String var1);

    public abstract Object getProperty(String var1, Object var2);

    public abstract void setProperty(String var1, Object var2);

    public abstract Object removeProperty(String var1);

    public abstract Iterable<String> getPropertyKeys();

    public abstract Iterable<Relationship> getRelationships(Direction var1);

    public boolean equals(Object o) {
        if (!(o instanceof NodeOrRelationship)) {
            return false;
        }
        return this.getTypedId().equals(((NodeOrRelationship)o).getTypedId());
    }

    public int hashCode() {
        return this.getTypedId().hashCode();
    }

    static class WrapRelationship
    extends NodeOrRelationship {
        private WrapRelationship(Relationship rel) {
            super(rel);
        }

        private Relationship object() {
            return this.asRelationship();
        }

        @Override
        public String getType() {
            return NodeOrRelationship.TYPE_RELATIONSHIP;
        }

        @Override
        public long getId() {
            return this.object().getId();
        }

        @Override
        public boolean hasProperty(String key) {
            return this.object().hasProperty(key);
        }

        @Override
        public Object getProperty(String key) {
            return this.object().getProperty(key);
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            return this.object().getProperty(key, defaultValue);
        }

        @Override
        public void setProperty(String key, Object value) {
            this.object().setProperty(key, value);
        }

        @Override
        public Object removeProperty(String key) {
            return this.object().removeProperty(key);
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            return this.object().getPropertyKeys();
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction direction) {
            return new ArrayList<Relationship>();
        }
    }

    static class WrapNode
    extends NodeOrRelationship {
        private WrapNode(Node node) {
            super(node);
        }

        private Node object() {
            return this.asNode();
        }

        @Override
        public String getType() {
            return NodeOrRelationship.TYPE_NODE;
        }

        @Override
        public long getId() {
            return this.object().getId();
        }

        @Override
        public boolean hasProperty(String key) {
            return this.object().hasProperty(key);
        }

        @Override
        public Object getProperty(String key) {
            return this.object().getProperty(key);
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            return this.object().getProperty(key, defaultValue);
        }

        @Override
        public void setProperty(String key, Object value) {
            this.object().setProperty(key, value);
        }

        @Override
        public Object removeProperty(String key) {
            return this.object().removeProperty(key);
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            return this.object().getPropertyKeys();
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction direction) {
            return this.object().getRelationships(direction);
        }
    }
}

