package play.module.neo4j;

import java.util.List;

import models.User;

import org.junit.Before;
import org.junit.Test;

import play.modules.neo4j.exception.Neo4jException;
import play.modules.neo4j.util.Fixtures;
import play.test.UnitTest;

public class RelationTest extends UnitTest {

    @Before
    public void tearsUp() {
        Fixtures.loadYml("data.yml");
    }

    @Before
    public void tearsDown() {
        Fixtures.deleteDatabase();
    }

    @Test
    public void lazyLoadingTest() throws Neo4jException {
        List<User> users = User.findAll();
        for (int i = 0; i < users.size(); i++) {
            User user = users.get(i);
            if (user.login.equals("ben@gmail.com")) {
                assertEquals(1, user.classmates.size());
                assertEquals("osecher@gmail.com", user.classmates.get(0).email);
            }
        }
    }

    @Test
    public void simpleLoadingTest() throws Neo4jException {
        List<User> users = User.findAll();
        for (int i = 0; i < users.size(); i++) {
            User user = users.get(i);
            if (user.login.equals("ben@gmail.com")) {
                assertEquals(1, user.friends.size());
                assertEquals("osecher@gmail.com", user.friends.get(0).email);
            }
        }
    }

    @Test
    public void reverseLoadingTest() throws Neo4jException {
        List<User> users = User.findAll();
        for (int i = 0; i < users.size(); i++) {
            User user = users.get(i);
            if (user.login.equals("osecher@gmail.com")) {
                assertEquals(1, user.reversefriends.size());
                assertEquals("ben@gmail.com", user.friends.get(0).email);
            }
        }
    }
}
