/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;

final class DirectBufferPool {
    private static final int POOL_SIZE = 4;
    private static final ThreadLocal<SoftReference<ByteBuffer>[]> pool = new ThreadLocal<SoftReference<ByteBuffer>[]>(){

        @Override
        protected SoftReference<ByteBuffer>[] initialValue() {
            return new SoftReference[4];
        }
    };

    static final ByteBuffer acquire(ChannelBuffer src) {
        ByteBuffer dst = DirectBufferPool.acquire(src.readableBytes());
        src.getBytes(src.readerIndex(), dst);
        dst.rewind();
        return dst;
    }

    static final ByteBuffer acquire(int size) {
        SoftReference<ByteBuffer>[] pool = DirectBufferPool.pool.get();
        for (int i = 0; i < 4; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            if (ref == null) continue;
            ByteBuffer buf = ref.get();
            if (buf == null) {
                pool[i] = null;
                continue;
            }
            if (buf.capacity() < size) continue;
            pool[i] = null;
            buf.rewind();
            buf.limit(size);
            return buf;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(DirectBufferPool.normalizeCapacity(size));
        buf.limit(size);
        return buf;
    }

    static final void release(ByteBuffer buffer) {
        SoftReference<ByteBuffer>[] pool = DirectBufferPool.pool.get();
        for (int i = 0; i < 4; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            if (ref != null && ref.get() != null) continue;
            pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
        int capacity = buffer.capacity();
        for (int i = 0; i < 4; ++i) {
            SoftReference<ByteBuffer> ref = pool[i];
            ByteBuffer pooled = ref.get();
            if (pooled == null) {
                pool[i] = null;
                continue;
            }
            if (pooled.capacity() >= capacity) continue;
            pool[i] = new SoftReference<ByteBuffer>(buffer);
            return;
        }
    }

    private static final int normalizeCapacity(int capacity) {
        return (capacity & 0xFFFFF000) + 4096;
    }

    private DirectBufferPool() {
    }
}

