/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.DirectBufferPool;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelConfig;
import org.jboss.netty.channel.socket.nio.NioProviderMetadata;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.LinkedTransferQueue;
import org.jboss.netty.util.internal.NonReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioDatagramWorker
implements Runnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioDatagramWorker.class);
    private final int id;
    private final int bossId;
    private final Executor executor;
    private boolean started;
    private volatile Thread thread;
    volatile Selector selector;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final ReadWriteLock selectorGuard = new ReentrantReadWriteLock();
    private final Object startStopLock = new Object();
    private final Queue<Runnable> registerTaskQueue = new LinkedTransferQueue<Runnable>();
    private final Queue<Runnable> writeTaskQueue = new LinkedTransferQueue<Runnable>();
    private volatile int cancelledKeys;

    NioDatagramWorker(int bossId, int id, Executor executor) {
        this.bossId = bossId;
        this.id = id;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(NioDatagramChannel channel, ChannelFuture future) {
        Selector selector;
        ChannelRegistionTask channelRegTask = new ChannelRegistionTask(channel, future);
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                try {
                    this.selector = selector = Selector.open();
                }
                catch (Throwable t) {
                    throw new ChannelException("Failed to create a selector.", t);
                }
                boolean success = false;
                try {
                    this.executor.execute(new ThreadRenamingRunnable(this, "New I/O datagram worker #" + this.bossId + "'-'" + this.id));
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            selector.close();
                        }
                        catch (Throwable t) {
                            logger.warn("Failed to close a selector.", t);
                        }
                        selector = null;
                        this.selector = null;
                    }
                }
            }
            selector = this.selector;
            assert (selector != null && selector.isOpen());
            this.started = true;
            boolean offered = this.registerTaskQueue.offer(channelRegTask);
            assert (offered);
        }
        if (this.wakenUp.compareAndSet(false, true)) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        Selector selector = this.selector;
        boolean shutdown = false;
        while (true) {
            this.wakenUp.set(false);
            if (NioProviderMetadata.CONSTRAINT_LEVEL != 0) {
                this.selectorGuard.writeLock().lock();
                this.selectorGuard.writeLock().unlock();
            }
            try {
                selector.select(500L);
                if (this.wakenUp.get()) {
                    selector.wakeup();
                }
                this.cancelledKeys = 0;
                this.processRegisterTaskQueue();
                this.processWriteTaskQueue();
                this.processSelectedKeys(selector.selectedKeys());
                if (selector.keys().isEmpty()) {
                    if (shutdown || this.executor instanceof ExecutorService && ((ExecutorService)this.executor).isShutdown()) {
                        Object object = this.startStopLock;
                        synchronized (object) {
                            if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                this.started = false;
                                try {
                                    selector.close();
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to close a selector.", e);
                                }
                                finally {
                                    this.selector = null;
                                }
                                break;
                            }
                            shutdown = false;
                            continue;
                        }
                    }
                    shutdown = true;
                    continue;
                }
                shutdown = false;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void processRegisterTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.registerTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processWriteTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.writeTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processSelectedKeys(Set<SelectionKey> selectedKeys) throws IOException {
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if (((readyOps & 1) != 0 || readyOps == 0) && !this.read(k)) continue;
                if ((readyOps & 4) != 0) {
                    this.write((NioDatagramChannel)k.attachment());
                }
            }
            catch (CancelledKeyException e) {
                this.close(k);
            }
            if (!this.cleanUpCancelledKeys()) continue;
            break;
        }
    }

    private boolean cleanUpCancelledKeys() throws IOException {
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.selector.selectNow();
            return true;
        }
        return false;
    }

    private boolean read(SelectionKey key) {
        NioDatagramChannel channel = (NioDatagramChannel)key.attachment();
        NioDatagramChannelConfig cfg = channel.getConfig();
        ReceiveBufferSizePredictor predictor = cfg.getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = cfg.getBufferFactory();
        DatagramChannel nioChannel = (DatagramChannel)key.channel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(predictor.nextReceiveBufferSize()).order(bufferFactory.getDefaultOrder());
        boolean failure = true;
        SocketAddress remoteAddress = null;
        try {
            remoteAddress = nioChannel.receive(byteBuffer);
            failure = false;
        }
        catch (ClosedChannelException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (remoteAddress != null) {
            byteBuffer.flip();
            int readBytes = byteBuffer.remaining();
            if (readBytes > 0) {
                predictor.previousReceiveBufferSize(readBytes);
                Channels.fireMessageReceived(channel, (Object)bufferFactory.getBuffer(byteBuffer), remoteAddress);
            }
        }
        if (failure) {
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    private void close(SelectionKey k) {
        NioDatagramChannel ch = (NioDatagramChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(NioDatagramChannel channel) {
        Object object;
        int writtenBytes;
        boolean removeOpWrite;
        boolean addOpWrite;
        block32: {
            if (!channel.isOpen()) {
                this.cleanUpWriteBuffer(channel);
                return;
            }
            NonReentrantLock writeLock = channel.writeLock;
            if (!writeLock.tryLock()) {
                this.rescheduleWrite(channel);
                return;
            }
            Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
            int writeSpinCount = channel.getConfig().getWriteSpinCount();
            addOpWrite = false;
            removeOpWrite = false;
            writtenBytes = 0;
            block12: while (true) {
                while (true) {
                    ByteBuffer buf;
                    MessageEvent evt;
                    if ((evt = channel.currentWriteEvent) == null) {
                        channel.currentWriteEvent = evt = writeBuffer.poll();
                        if (evt == null) {
                            removeOpWrite = true;
                            break block32;
                        }
                        ChannelBuffer origBuf = (ChannelBuffer)evt.getMessage();
                        if (origBuf.isDirect()) {
                            channel.currentWriteBuffer = buf = origBuf.toByteBuffer();
                            channel.currentWriteBufferIsPooled = false;
                        } else {
                            channel.currentWriteBuffer = buf = DirectBufferPool.acquire(origBuf);
                            channel.currentWriteBufferIsPooled = true;
                        }
                    } else {
                        buf = channel.currentWriteBuffer;
                    }
                    try {
                        int i;
                        int localWrittenBytes = 0;
                        DatagramChannel dch = channel.getDatagramChannel();
                        SocketAddress raddr = evt.getRemoteAddress();
                        if (raddr == null) {
                            for (i = writeSpinCount; i > 0; --i) {
                                localWrittenBytes = dch.write(buf);
                                if (localWrittenBytes == 0) continue;
                                writtenBytes += localWrittenBytes;
                                break;
                            }
                        } else {
                            for (i = writeSpinCount; i > 0; --i) {
                                localWrittenBytes = dch.send(buf, raddr);
                                if (localWrittenBytes == 0) continue;
                                writtenBytes += localWrittenBytes;
                                break;
                            }
                        }
                        if (localWrittenBytes > 0) {
                            if (channel.currentWriteBufferIsPooled) {
                                DirectBufferPool.release(buf);
                            }
                            ChannelFuture future = evt.getFuture();
                            channel.currentWriteEvent = null;
                            channel.currentWriteBuffer = null;
                            evt = null;
                            buf = null;
                            future.setSuccess();
                            continue block12;
                        }
                        addOpWrite = true;
                        break block32;
                    }
                    catch (AsynchronousCloseException e) {
                        continue;
                    }
                    catch (Throwable t) {
                        if (channel.currentWriteBufferIsPooled) {
                            DirectBufferPool.release(buf);
                        }
                        ChannelFuture future = evt.getFuture();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        buf = null;
                        evt = null;
                        future.setFailure(t);
                        Channels.fireExceptionCaught(channel, t);
                        continue;
                    }
                    break;
                }
                break;
            }
            finally {
                writeLock.unlock();
            }
        }
        Channels.fireWriteComplete(channel, writtenBytes);
        if (addOpWrite) {
            object = channel.interestOpsLock;
            synchronized (object) {
                int interestOps = channel.getRawInterestOps();
                if ((interestOps & 4) == 0) {
                    this.setInterestOps0(channel, interestOps |= 4);
                }
            }
        }
        if (removeOpWrite) {
            object = channel.interestOpsLock;
            synchronized (object) {
                int interestOps = channel.getRawInterestOps();
                if ((interestOps & 4) != 0) {
                    this.setInterestOps0(channel, interestOps &= 0xFFFFFFFB);
                }
            }
        }
    }

    private void rescheduleWrite(NioDatagramChannel channel) {
        Selector selector;
        if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
            boolean offered = this.writeTaskQueue.offer(channel.writeTask);
            assert (offered);
        }
        if ((selector = this.selector) != null && this.wakenUp.compareAndSet(false, true)) {
            selector.wakeup();
        }
    }

    static void disconnect(NioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        try {
            channel.getDatagramChannel().disconnect();
            future.setSuccess();
            if (connected) {
                Channels.fireChannelDisconnected(channel);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    void close(NioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.getDatagramChannel().close();
            ++this.cancelledKeys;
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                this.cleanUpWriteBuffer(channel);
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpWriteBuffer(NioDatagramChannel channel) {
        boolean fireExceptionCaught;
        Exception cause;
        block9: {
            cause = null;
            fireExceptionCaught = false;
            channel.writeLock.lock();
            try {
                Queue<MessageEvent> writeBuffer;
                MessageEvent evt = channel.currentWriteEvent;
                ByteBuffer buf = channel.currentWriteBuffer;
                if (evt != null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                    if (channel.currentWriteBufferIsPooled) {
                        DirectBufferPool.release(buf);
                    }
                    ChannelFuture future = evt.getFuture();
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    future.setFailure(cause);
                    fireExceptionCaught = true;
                }
                if ((writeBuffer = channel.writeBufferQueue).isEmpty()) break block9;
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                }
                while ((evt = writeBuffer.poll()) != null) {
                    evt.getFuture().setFailure(cause);
                    fireExceptionCaught = true;
                }
            }
            finally {
                channel.writeLock.unlock();
            }
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(channel, (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterestOps(NioDatagramChannel channel, ChannelFuture future, int interestOps) {
        interestOps &= 0xFFFFFFFB;
        interestOps |= channel.getRawInterestOps() & 4;
        try {
            boolean changed;
            Object object = channel.interestOpsLock;
            synchronized (object) {
                changed = this.setInterestOps0(channel, interestOps);
            }
            future.setSuccess();
            if (changed) {
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (CancelledKeyException e) {
            ClosedChannelException cce = new ClosedChannelException();
            future.setFailure(cce);
            Channels.fireExceptionCaught(channel, (Throwable)cce);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setInterestOps0(NioDatagramChannel channel, int interestOps) {
        Selector selector = this.selector;
        SelectionKey key = channel.getDatagramChannel().keyFor(selector);
        if (key == null || selector == null) {
            channel.setRawInterestOpsNow(interestOps);
            return false;
        }
        switch (NioProviderMetadata.CONSTRAINT_LEVEL) {
            case 0: {
                if (channel.getRawInterestOps() == interestOps) break;
                key.interestOps(interestOps);
                if (Thread.currentThread() != this.thread && this.wakenUp.compareAndSet(false, true)) {
                    selector.wakeup();
                }
                return true;
            }
            case 1: 
            case 2: {
                if (channel.getRawInterestOps() == interestOps) break;
                if (Thread.currentThread() == this.thread) {
                    key.interestOps(interestOps);
                    return true;
                }
                this.selectorGuard.readLock().lock();
                try {
                    if (this.wakenUp.compareAndSet(false, true)) {
                        selector.wakeup();
                    }
                    key.interestOps(interestOps);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.selectorGuard.readLock().unlock();
                }
            }
            default: {
                throw new Error();
            }
        }
        return false;
    }

    private final class ChannelRegistionTask
    implements Runnable {
        private final NioDatagramChannel channel;
        private final ChannelFuture future;

        ChannelRegistionTask(NioDatagramChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InetSocketAddress localAddress = this.channel.getLocalAddress();
            if (localAddress == null) {
                if (this.future != null) {
                    this.future.setFailure(new ClosedChannelException());
                }
                NioDatagramWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                return;
            }
            try {
                Object object = this.channel.interestOpsLock;
                synchronized (object) {
                    this.channel.getDatagramChannel().register(NioDatagramWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                }
                if (this.future != null) {
                    this.future.setSuccess();
                }
            }
            catch (ClosedChannelException e) {
                if (this.future != null) {
                    this.future.setFailure(e);
                }
                NioDatagramWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                throw new ChannelException("Failed to register a socket to the selector.", e);
            }
        }
    }
}

