/*
 * Decompiled with CFR 0.152.
 */
package play.modules.netty;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.SocketAddress;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import play.Play;
import play.modules.netty.FileChannelBuffer;

@ChannelPipelineCoverage(value="one")
public class StreamChunkAggregator
extends SimpleChannelUpstreamHandler {
    private volatile HttpMessage currentMessage;
    private volatile BufferedWriter out;
    private final int maxContentLength;
    private volatile File file;

    public StreamChunkAggregator(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpChunk)) {
            ctx.sendUpstream((ChannelEvent)e);
            return;
        }
        HttpMessage currentMessage = this.currentMessage;
        BufferedWriter out = this.out;
        File localFile = this.file;
        if (currentMessage == null) {
            HttpMessage m = (HttpMessage)msg;
            if (m.isChunked()) {
                String localName = UUID.randomUUID().toString();
                List encodings = m.getHeaders("Transfer-Encoding");
                encodings.remove("chunked");
                if (encodings.isEmpty()) {
                    m.removeHeader("Transfer-Encoding");
                }
                this.currentMessage = m;
                this.file = new File(Play.tmpDir, localName);
                FileWriter fstream = new FileWriter(this.file, true);
                this.out = new BufferedWriter(fstream);
            } else {
                ctx.sendUpstream((ChannelEvent)e);
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            if (this.maxContentLength != -1 && localFile.length() > (long)(this.maxContentLength - chunk.getContent().readableBytes())) {
                currentMessage.setHeader("Warning", (Object)"play.netty.content.length.exceeded");
            } else {
                byte[] b = new byte[chunk.getContent().capacity()];
                chunk.getContent().getBytes(0, b);
                IOUtils.copy((InputStream)new ByteArrayInputStream(b), (Writer)out);
                if (chunk.isLast()) {
                    currentMessage.setHeader("Content-Length", (Object)String.valueOf(localFile.length()));
                    currentMessage.setContent((ChannelBuffer)new FileChannelBuffer(localFile));
                    out.flush();
                    out.close();
                    this.out = null;
                    this.currentMessage = null;
                    this.file = null;
                    Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)currentMessage, (SocketAddress)e.getRemoteAddress());
                }
            }
        }
    }
}

