/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.bootstrap;

import java.net.SocketAddress;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineException;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ClientBootstrap
extends Bootstrap {
    public ClientBootstrap() {
    }

    public ClientBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public ChannelFuture connect() {
        SocketAddress remoteAddress = (SocketAddress)this.getOption("remoteAddress");
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress option is not set.");
        }
        return this.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remotedAddress");
        }
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        return this.connect(remoteAddress, localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        ChannelPipeline pipeline;
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        LinkedBlockingQueue<ChannelFuture> futureQueue = new LinkedBlockingQueue<ChannelFuture>();
        try {
            pipeline = this.getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            throw new ChannelPipelineException("Failed to initialize a pipeline.", e);
        }
        pipeline.addFirst("connector", new Connector(this, remoteAddress, localAddress, futureQueue));
        this.getFactory().newChannel(pipeline);
        ChannelFuture future = null;
        boolean interrupted = false;
        do {
            try {
                future = (ChannelFuture)futureQueue.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (future == null);
        pipeline.remove("connector");
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return future;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ChannelPipelineCoverage(value="one")
    static final class Connector
    extends SimpleChannelUpstreamHandler {
        private final Bootstrap bootstrap;
        private final SocketAddress localAddress;
        private final BlockingQueue<ChannelFuture> futureQueue;
        private final SocketAddress remoteAddress;
        private volatile boolean finished = false;

        Connector(Bootstrap bootstrap, SocketAddress remoteAddress, SocketAddress localAddress, BlockingQueue<ChannelFuture> futureQueue) {
            this.bootstrap = bootstrap;
            this.localAddress = localAddress;
            this.futureQueue = futureQueue;
            this.remoteAddress = remoteAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelOpen(ChannelHandlerContext context, ChannelStateEvent event) {
            try {
                event.getChannel().getConfig().setOptions(this.bootstrap.getOptions());
            }
            finally {
                context.sendUpstream(event);
            }
            if (this.localAddress != null) {
                event.getChannel().bind(this.localAddress);
            } else {
                this.finished = this.futureQueue.offer(event.getChannel().connect(this.remoteAddress));
                assert (this.finished);
            }
        }

        @Override
        public void channelBound(ChannelHandlerContext context, ChannelStateEvent event) {
            context.sendUpstream(event);
            if (this.localAddress != null) {
                this.finished = this.futureQueue.offer(event.getChannel().connect(this.remoteAddress));
                assert (this.finished);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            ctx.sendUpstream(e);
            Throwable cause = e.getCause();
            if (!(cause instanceof NotYetConnectedException) && !this.finished) {
                e.getChannel().close();
                this.finished = this.futureQueue.offer(Channels.failedFuture(e.getChannel(), cause));
                assert (this.finished);
            }
        }
    }
}

