/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;

public class QueryStringEncoder {
    private final String charset;
    private final String uri;
    private final List<Param> params = new ArrayList<Param>();

    public QueryStringEncoder(String uri) {
        this(uri, "UTF-8");
    }

    public QueryStringEncoder(String uri, String charset) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.uri = uri;
        this.charset = charset;
    }

    public void addParam(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.params.add(new Param(name, value));
    }

    public URI toUri() throws URISyntaxException {
        return new URI(this.toString());
    }

    public String toString() {
        if (this.params.isEmpty()) {
            return this.uri;
        }
        StringBuilder sb = new StringBuilder(this.uri).append("?");
        for (int i = 0; i < this.params.size(); ++i) {
            Param param = this.params.get(i);
            sb.append(QueryStringEncoder.encodeComponent(param.name, this.charset));
            sb.append("=");
            sb.append(QueryStringEncoder.encodeComponent(param.value, this.charset));
            if (i == this.params.size() - 1) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    private static String encodeComponent(String s, String charset) {
        try {
            System.err.println("encodeComponent " + s);
            return URLEncoder.encode(s.replaceAll("\\+", " "), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(charset);
        }
    }

    private static final class Param {
        final String name;
        final String value;

        Param(String name, String value) {
            this.value = value;
            this.name = name;
        }
    }
}

