/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.ssl.SslBufferPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.ImmediateExecutor;

public class SslHandler
extends FrameDecoder
implements ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private static SslBufferPool defaultBufferPool;
    private final SSLEngine engine;
    private final SslBufferPool bufferPool;
    private final Executor delegatedTaskExecutor;
    private final boolean startTls;
    final Object handshakeLock = new Object();
    private boolean initialHandshake;
    private boolean handshaking;
    private volatile boolean handshaken;
    private volatile ChannelFuture handshakeFuture;
    private final AtomicBoolean sentFirstMessage = new AtomicBoolean();
    private final AtomicBoolean sentCloseNotify = new AtomicBoolean();
    int ignoreClosedChannelException;
    final Object ignoreClosedChannelExceptionLock = new Object();
    private final Queue<PendingWrite> pendingUnencryptedWrites = new LinkedList<PendingWrite>();
    private final Queue<MessageEvent> pendingEncryptedWrites = new LinkedList<MessageEvent>();

    public static synchronized SslBufferPool getDefaultBufferPool() {
        if (defaultBufferPool == null) {
            defaultBufferPool = new SslBufferPool();
        }
        return defaultBufferPool;
    }

    public SslHandler(SSLEngine engine) {
        this(engine, SslHandler.getDefaultBufferPool(), (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool) {
        this(engine, bufferPool, (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, SslHandler.getDefaultBufferPool(), startTls);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls) {
        this(engine, bufferPool, startTls, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this(engine, SslHandler.getDefaultBufferPool(), delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, Executor delegatedTaskExecutor) {
        this(engine, bufferPool, false, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        this(engine, SslHandler.getDefaultBufferPool(), startTls, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls, Executor delegatedTaskExecutor) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        if (bufferPool == null) {
            throw new NullPointerException("bufferPool");
        }
        if (delegatedTaskExecutor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.delegatedTaskExecutor = delegatedTaskExecutor;
        this.startTls = startTls;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture handshake(Channel channel) throws SSLException {
        ChannelFuture handshakeFuture;
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.handshaking) {
                return this.handshakeFuture;
            }
            this.engine.beginHandshake();
            this.runDelegatedTasks();
            handshakeFuture = this.handshakeFuture = Channels.future(channel);
            this.handshaking = true;
        }
        this.wrapNonAppData(this.context(channel), channel);
        return handshakeFuture;
    }

    public ChannelFuture close(Channel channel) throws SSLException {
        ChannelHandlerContext ctx = this.context(channel);
        this.engine.closeOutbound();
        return this.wrapNonAppData(ctx, channel);
    }

    private ChannelHandlerContext context(Channel channel) {
        return channel.getPipeline().getContext(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext context, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.closeOutboundAndChannel(context, (ChannelStateEvent)e);
                    return;
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            context.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        if (!(e.getMessage() instanceof ChannelBuffer)) {
            context.sendDownstream(evt);
            return;
        }
        if (this.startTls && this.sentFirstMessage.compareAndSet(false, true)) {
            context.sendDownstream(evt);
            return;
        }
        ChannelBuffer msg = (ChannelBuffer)e.getMessage();
        PendingWrite pendingWrite = msg.readable() ? new PendingWrite(evt.getFuture(), msg.toByteBuffer(msg.readerIndex(), msg.readableBytes())) : new PendingWrite(evt.getFuture(), null);
        Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
        synchronized (queue) {
            boolean offered = this.pendingUnencryptedWrites.offer(pendingWrite);
            assert (offered);
        }
        this.wrap(context, evt.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.handshaking) {
                this.handshakeFuture.setFailure(new ClosedChannelException());
            }
        }
        try {
            super.channelDisconnected(ctx, e);
        }
        finally {
            this.unwrap(ctx, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
            this.engine.closeOutbound();
            if (!this.sentCloseNotify.get() && this.handshaken) {
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException ex) {
                    logger.debug("Failed to clean up SSLEngine.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            String message;
            if (cause instanceof ClosedChannelException) {
                Object object = this.ignoreClosedChannelExceptionLock;
                synchronized (object) {
                    if (this.ignoreClosedChannelException > 0) {
                        --this.ignoreClosedChannelException;
                        logger.debug("Swallowing an exception raised while writing non-app data", cause);
                        return;
                    }
                }
            } else if (this.engine.isOutboundDone() && IGNORABLE_ERROR_MESSAGE.matcher(message = String.valueOf(cause.getMessage()).toLowerCase()).matches()) {
                logger.debug("Swallowing a 'connection reset by peer / broken pipe' error occurred while writing 'closure_notify'", cause);
                Channels.close(ctx, Channels.succeededFuture(e.getChannel()));
                return;
            }
        }
        ctx.sendUpstream(e);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 2) {
            return null;
        }
        int packetLength = buffer.getShort(buffer.readerIndex()) & 0xFFFF;
        if ((packetLength & 0x8000) != 0) {
            packetLength &= Short.MAX_VALUE;
            packetLength += 2;
        } else {
            if (buffer.readableBytes() < 5) {
                return null;
            }
            packetLength = (buffer.getShort(buffer.readerIndex() + 3) & 0xFFFF) + 5;
        }
        if (buffer.readableBytes() < packetLength) {
            return null;
        }
        int packetOffset = buffer.readerIndex();
        buffer.skipBytes(packetLength);
        return this.unwrap(ctx, channel, buffer, packetOffset, packetLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture wrap(ChannelHandlerContext context, Channel channel) throws SSLException {
        boolean needsUnwrap;
        ChannelFuture future;
        block44: {
            IllegalStateException cause;
            PendingWrite pendingWrite;
            future = null;
            ByteBuffer outNetBuf = this.bufferPool.acquire();
            boolean success = true;
            boolean offered = false;
            needsUnwrap = false;
            try {
                block25: while (true) {
                    Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
                    synchronized (queue) {
                        pendingWrite = this.pendingUnencryptedWrites.peek();
                        if (pendingWrite == null) {
                            break;
                        }
                        ByteBuffer outAppBuf = pendingWrite.outAppBuf;
                        if (outAppBuf == null) {
                            this.pendingUnencryptedWrites.remove();
                            this.offerEncryptedWriteRequest(new DownstreamMessageEvent(channel, pendingWrite.future, ChannelBuffers.EMPTY_BUFFER, channel.getRemoteAddress()));
                            offered = true;
                        } else {
                            SSLEngineResult result = null;
                            try {
                                Object object = this.handshakeLock;
                                synchronized (object) {
                                    result = this.engine.wrap(outAppBuf, outNetBuf);
                                }
                            }
                            finally {
                                if (!outAppBuf.hasRemaining()) {
                                    this.pendingUnencryptedWrites.remove();
                                }
                            }
                            if (result.bytesProduced() > 0) {
                                outNetBuf.flip();
                                ChannelBuffer msg = ChannelBuffers.buffer(outNetBuf.remaining());
                                msg.writeBytes(outNetBuf.array(), 0, msg.capacity());
                                outNetBuf.clear();
                                future = pendingWrite.outAppBuf.hasRemaining() ? Channels.succeededFuture(channel) : pendingWrite.future;
                                DownstreamMessageEvent encryptedWrite = new DownstreamMessageEvent(channel, future, msg, channel.getRemoteAddress());
                                this.offerEncryptedWriteRequest(encryptedWrite);
                                offered = true;
                            } else {
                                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                                switch (handshakeStatus) {
                                    case NEED_WRAP: {
                                        if (outAppBuf.hasRemaining()) break;
                                        break block25;
                                    }
                                    case NEED_UNWRAP: {
                                        needsUnwrap = true;
                                        break block25;
                                    }
                                    case NEED_TASK: {
                                        this.runDelegatedTasks();
                                        break;
                                    }
                                    case FINISHED: 
                                    case NOT_HANDSHAKING: {
                                        if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                                            this.setHandshakeSuccess(channel);
                                        }
                                        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                                            success = false;
                                        }
                                        break block25;
                                    }
                                    default: {
                                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                                    }
                                }
                            }
                        }
                    }
                }
                this.bufferPool.release(outNetBuf);
                if (offered) {
                    this.flushPendingEncryptedWrites(context);
                }
                if (success) break block44;
                cause = new IllegalStateException("SSLEngine already closed");
            }
            catch (SSLException e) {
                try {
                    success = false;
                    this.setHandshakeFailure(channel, e);
                    throw e;
                }
                catch (Throwable throwable) {
                    this.bufferPool.release(outNetBuf);
                    if (offered) {
                        this.flushPendingEncryptedWrites(context);
                    }
                    if (!success) {
                        IllegalStateException cause2 = new IllegalStateException("SSLEngine already closed");
                        while (true) {
                            PendingWrite pendingWrite2;
                            Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
                            synchronized (queue) {
                                pendingWrite2 = this.pendingUnencryptedWrites.poll();
                                if (pendingWrite2 == null) {
                                    break;
                                }
                            }
                            pendingWrite2.future.setFailure(cause2);
                        }
                    }
                    throw throwable;
                }
            }
            while (true) {
                Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
                synchronized (queue) {
                    pendingWrite = this.pendingUnencryptedWrites.poll();
                    if (pendingWrite == null) {
                        break;
                    }
                }
                pendingWrite.future.setFailure(cause);
            }
        }
        if (needsUnwrap) {
            this.unwrap(context, channel, ChannelBuffers.EMPTY_BUFFER, 0, 0);
        }
        if (future == null) {
            future = Channels.succeededFuture(channel);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEncryptedWriteRequest(MessageEvent encryptedWrite) {
        boolean offered;
        if (Thread.holdsLock(this.pendingEncryptedWrites)) {
            offered = this.pendingEncryptedWrites.offer(encryptedWrite);
        } else {
            Queue<MessageEvent> queue = this.pendingEncryptedWrites;
            synchronized (queue) {
                offered = this.pendingEncryptedWrites.offer(encryptedWrite);
            }
        }
        assert (offered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingEncryptedWrites(ChannelHandlerContext ctx) {
        if (Thread.holdsLock(this.pendingEncryptedWrites)) {
            return;
        }
        Queue<MessageEvent> queue = this.pendingEncryptedWrites;
        synchronized (queue) {
            if (this.pendingEncryptedWrites.isEmpty()) {
                return;
            }
        }
        queue = this.pendingEncryptedWrites;
        synchronized (queue) {
            MessageEvent e;
            while ((e = this.pendingEncryptedWrites.poll()) != null) {
                ctx.sendDownstream(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture wrapNonAppData(ChannelHandlerContext ctx, Channel channel) throws SSLException {
        ChannelFuture future = null;
        ByteBuffer outNetBuf = this.bufferPool.acquire();
        try {
            SSLEngineResult result;
            block14: do {
                Object object = this.handshakeLock;
                synchronized (object) {
                    result = this.engine.wrap(EMPTY_BUFFER, outNetBuf);
                }
                if (result.bytesProduced() > 0) {
                    outNetBuf.flip();
                    ChannelBuffer msg = ChannelBuffers.buffer(outNetBuf.remaining());
                    msg.writeBytes(outNetBuf.array(), 0, msg.capacity());
                    outNetBuf.clear();
                    future = Channels.future(channel);
                    future.addListener(new ChannelFutureListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.getCause() instanceof ClosedChannelException) {
                                Object object = SslHandler.this.ignoreClosedChannelExceptionLock;
                                synchronized (object) {
                                    ++SslHandler.this.ignoreClosedChannelException;
                                }
                            }
                        }
                    });
                    Channels.write(ctx, future, msg);
                }
                switch (result.getHandshakeStatus()) {
                    case FINISHED: {
                        this.setHandshakeSuccess(channel);
                        this.runDelegatedTasks();
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case NEED_UNWRAP: {
                        if (Thread.holdsLock(this.handshakeLock)) continue block14;
                        this.unwrap(ctx, channel, ChannelBuffers.EMPTY_BUFFER, 0, 0);
                        break;
                    }
                    case NEED_WRAP: 
                    case NOT_HANDSHAKING: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                    }
                }
            } while (result.bytesProduced() != 0);
        }
        catch (SSLException e) {
            this.setHandshakeFailure(channel, e);
            throw e;
        }
        finally {
            this.bufferPool.release(outNetBuf);
        }
        if (future == null) {
            future = Channels.succeededFuture(channel);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuffer unwrap(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, int offset, int length) throws SSLException {
        ByteBuffer inNetBuf = buffer.toByteBuffer(offset, length);
        ByteBuffer outAppBuf = this.bufferPool.acquire();
        try {
            Object object;
            boolean needsWrap = false;
            block18: while (true) {
                object = this.handshakeLock;
                synchronized (object) {
                    if (this.initialHandshake && !this.engine.getUseClientMode() && !this.engine.isInboundDone() && !this.engine.isOutboundDone()) {
                        this.handshake(channel);
                        this.initialHandshake = false;
                    }
                    SSLEngineResult result = this.engine.unwrap(inNetBuf, outAppBuf);
                    switch (result.getHandshakeStatus()) {
                        case NEED_UNWRAP: {
                            if (inNetBuf.hasRemaining() && !this.engine.isInboundDone()) break;
                            break block18;
                        }
                        case NEED_WRAP: {
                            this.wrapNonAppData(ctx, channel);
                            break;
                        }
                        case NEED_TASK: {
                            this.runDelegatedTasks();
                            break;
                        }
                        case FINISHED: {
                            this.setHandshakeSuccess(channel);
                            needsWrap = true;
                            break block18;
                        }
                        case NOT_HANDSHAKING: {
                            needsWrap = true;
                            break block18;
                        }
                        default: {
                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                        }
                    }
                }
            }
            if (needsWrap && !Thread.holdsLock(this.handshakeLock) && !Thread.holdsLock(this.pendingEncryptedWrites)) {
                this.wrap(ctx, channel);
            }
            outAppBuf.flip();
            if (outAppBuf.hasRemaining()) {
                ChannelBuffer frame = ChannelBuffers.buffer(outAppBuf.remaining());
                frame.writeBytes(outAppBuf.array(), 0, frame.capacity());
                object = frame;
                return object;
            }
            ChannelBuffer channelBuffer = null;
            return channelBuffer;
        }
        catch (SSLException e) {
            this.setHandshakeFailure(channel, e);
            throw e;
        }
        finally {
            this.bufferPool.release(outAppBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelegatedTasks() {
        while (true) {
            Runnable task;
            Object object = this.handshakeLock;
            synchronized (object) {
                task = this.engine.getDelegatedTask();
            }
            if (task == null) break;
            this.delegatedTaskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = SslHandler.this.handshakeLock;
                    synchronized (object) {
                        task.run();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeSuccess(Channel channel) {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.handshaking = false;
            this.handshaken = true;
            if (this.handshakeFuture == null) {
                this.handshakeFuture = Channels.future(channel);
            }
        }
        this.handshakeFuture.setSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(Channel channel, SSLException cause) {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (!this.handshaking) {
                return;
            }
            this.handshaking = false;
            this.handshaken = false;
            if (this.handshakeFuture == null) {
                this.handshakeFuture = Channels.future(channel);
            }
        }
        this.handshakeFuture.setFailure(cause);
    }

    private void closeOutboundAndChannel(ChannelHandlerContext context, ChannelStateEvent e) throws SSLException {
        if (!e.getChannel().isConnected()) {
            context.sendDownstream(e);
            return;
        }
        this.unwrap(context, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
        if (!this.engine.isInboundDone() && this.sentCloseNotify.compareAndSet(false, true)) {
            this.engine.closeOutbound();
            ChannelFuture closeNotifyFuture = this.wrapNonAppData(context, e.getChannel());
            closeNotifyFuture.addListener(new ClosingChannelFutureListener(context, e));
            return;
        }
        context.sendDownstream(e);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext context;
        private final ChannelStateEvent e;

        ClosingChannelFutureListener(ChannelHandlerContext context, ChannelStateEvent e) {
            this.context = context;
            this.e = e;
        }

        public void operationComplete(ChannelFuture closeNotifyFuture) throws Exception {
            if (!(closeNotifyFuture.getCause() instanceof ClosedChannelException)) {
                Channels.close(this.context, this.e.getFuture());
            }
        }
    }

    private static final class PendingWrite {
        final ChannelFuture future;
        final ByteBuffer outAppBuf;

        PendingWrite(ChannelFuture future, ByteBuffer outAppBuf) {
            this.future = future;
            this.outAppBuf = outAppBuf;
        }
    }
}

