/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util.internal;

import java.util.ArrayList;

public class ConversionUtil {
    public static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    public static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        String s = String.valueOf(value);
        if (s.length() == 0) {
            return false;
        }
        try {
            return Integer.parseInt(s) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            switch (Character.toUpperCase(s.charAt(0))) {
                case 'T': 
                case 'Y': {
                    return true;
                }
            }
            return false;
        }
    }

    private ConversionUtil() {
    }

    public static String[] toStringArray(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Iterable) {
            ArrayList<String> answer = new ArrayList<String>();
            for (Object v : (Iterable)value) {
                if (v == null) {
                    answer.add(null);
                    continue;
                }
                answer.add(String.valueOf(v));
            }
            return answer.toArray(new String[answer.size()]);
        }
        return String.valueOf(value).split("[, \\t\\n\\r\\f\\e\\a]");
    }
}

