/*
 * Decompiled with CFR 0.152.
 */
package play.modules.netty;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.jboss.netty.buffer.AbstractChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;
import org.jboss.netty.buffer.WrappedChannelBuffer;

public class FileChannelBuffer
extends AbstractChannelBuffer
implements WrappedChannelBuffer {
    private final File file;
    private final FileInputStream is;

    public FileChannelBuffer(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            this.file = file;
            this.is = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    public ChannelBuffer unwrap() {
        throw new RuntimeException();
    }

    public ChannelBufferFactory factory() {
        throw new RuntimeException();
    }

    public ByteOrder order() {
        throw new RuntimeException();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new RuntimeException();
    }

    public int arrayOffset() {
        throw new RuntimeException();
    }

    public void discardReadBytes() {
        throw new RuntimeException();
    }

    public void setByte(int index, byte value) {
        throw new RuntimeException();
    }

    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        throw new RuntimeException();
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new RuntimeException();
    }

    public void setBytes(int index, ByteBuffer src) {
        throw new RuntimeException();
    }

    public void setShort(int index, short value) {
        throw new RuntimeException();
    }

    public void setMedium(int index, int value) {
        throw new RuntimeException();
    }

    public void setInt(int index, int value) {
        throw new RuntimeException();
    }

    public void setLong(int index, long value) {
        throw new RuntimeException();
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new RuntimeException();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new RuntimeException();
    }

    public int readerIndex() {
        return 0;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        byte[] b = new byte[length];
        this.is.read(b, index, length);
        ByteBuffer bb = ByteBuffer.wrap(b);
        return out.write(bb);
    }

    public void setByte(int i, int i1) {
        throw new RuntimeException();
    }

    public void getBytes(int index, OutputStream out, int length) throws IOException {
        byte[] b = new byte[length];
        this.is.read(b, index, length);
        out.write(b, index, length);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        try {
            byte[] b = new byte[length];
            this.is.read(b, index, length);
            System.arraycopy(b, 0, dst, dstIndex, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        try {
            byte[] b = new byte[length];
            this.is.read(b, index, length);
            dst.writeBytes(b, dstIndex, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void getBytes(int index, ByteBuffer dst) {
        try {
            byte[] b = new byte[this.is.available() - index];
            this.is.read(b, index, this.is.available() - index);
            dst.put(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelBuffer duplicate() {
        throw new RuntimeException();
    }

    public ChannelBuffer copy(int index, int length) {
        throw new RuntimeException();
    }

    public ChannelBuffer slice(int index, int length) {
        throw new RuntimeException();
    }

    public byte getByte(int index) {
        throw new RuntimeException();
    }

    public short getShort(int index) {
        throw new RuntimeException();
    }

    public int getUnsignedMedium(int index) {
        throw new RuntimeException();
    }

    public int getInt(int index) {
        throw new RuntimeException();
    }

    public long getLong(int index) {
        throw new RuntimeException();
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        throw new RuntimeException();
    }

    public ByteBuffer[] toByteBuffers(int index, int length) {
        throw new RuntimeException();
    }

    public int capacity() {
        try {
            return this.is.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelBuffer readBytes(int length) {
        throw new RuntimeException();
    }

    public ChannelBuffer readBytes(ChannelBufferIndexFinder endIndexFinder) {
        throw new RuntimeException();
    }

    public ChannelBuffer readSlice(int length) {
        throw new RuntimeException();
    }

    public ChannelBuffer readSlice(ChannelBufferIndexFinder endIndexFinder) {
        throw new RuntimeException();
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.getBytes(0, dst, dstIndex, length);
    }

    public void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    public void readBytes(ChannelBuffer dst) {
        this.readBytes(dst, dst.writableBytes());
    }

    public void readBytes(ChannelBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    public void readBytes(ChannelBuffer dst, int dstIndex, int length) {
        this.getBytes(0, dst, dstIndex, length);
    }

    public void readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes(length);
        this.getBytes(0, dst);
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(0, out, length);
        return readBytes;
    }

    public void readBytes(OutputStream out, int length) throws IOException {
        this.checkReadableBytes(length);
        this.getBytes(0, out, length);
    }

    public String toString(int q, int a, String b) {
        throw new RuntimeException();
    }

    public void setShort(int a, int b) {
        throw new RuntimeException();
    }
}

