/*
 * Decompiled with CFR 0.152.
 */
package play.modules.netty;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.jboss.netty.handler.stream.ChunkedStream;
import play.Invoker;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.data.validation.Validation;
import play.exceptions.PlayException;
import play.exceptions.UnexpectedException;
import play.i18n.Messages;
import play.libs.MimeTypes;
import play.modules.netty.FileChannelBuffer;
import play.mvc.ActionInvoker;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.Scope;
import play.mvc.results.NotFound;
import play.mvc.results.RenderStatic;
import play.templates.JavaExtensions;
import play.templates.TemplateLoader;
import play.utils.Utils;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayHandler
extends SimpleChannelUpstreamHandler {
    private static final String signature = "Play! Framework;" + Play.version + ";" + Play.mode.name().toLowerCase();
    private static Map<String, RenderStatic> staticPathsCache = new HashMap<String, RenderStatic>();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Logger.trace((String)"messageReceived: begin", (Object[])new Object[0]);
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            HttpRequest nettyRequest = (HttpRequest)msg;
            try {
                Http.Request request = PlayHandler.parseRequest(ctx, nettyRequest);
                Http.Response response = new Http.Response();
                Http.Response.current.set(response);
                response.out = new ByteArrayOutputStream();
                boolean raw = false;
                for (PlayPlugin plugin : Play.plugins) {
                    if (!plugin.rawInvocation(request, response)) continue;
                    raw = true;
                    break;
                }
                if (raw) {
                    PlayHandler.copyResponse(ctx, request, response, nettyRequest);
                } else {
                    Invoker.invoke((Invoker.Invocation)new NettyInvocation(request, response, ctx, nettyRequest, e));
                }
            }
            catch (Exception ex) {
                PlayHandler.serve500(ex, ctx, nettyRequest);
            }
        }
        Logger.trace((String)"messageReceived: end", (Object[])new Object[0]);
    }

    void saveExceededSizeError(HttpRequest nettyRequest, Http.Request request, Http.Response response) {
        String warning = nettyRequest.getHeader("Warning");
        String length = nettyRequest.getHeader("Content-Length");
        if (warning != null) {
            try {
                StringBuilder error = new StringBuilder();
                error.append("\u0000");
                error.append("play.module.netty.maxContentLength");
                error.append(":");
                String size = null;
                try {
                    size = JavaExtensions.formatSize((Long)Long.parseLong(length));
                }
                catch (Exception e) {
                    size = length + " bytes";
                }
                error.append(Messages.get((Object)warning, (Object[])new Object[]{size}));
                error.append("\u0001");
                error.append(size);
                error.append("\u0000");
                if (request.cookies.get(Scope.COOKIE_PREFIX + "_ERRORS") != null && ((Http.Cookie)request.cookies.get((Object)new StringBuilder().append((String)Scope.COOKIE_PREFIX).append((String)"_ERRORS").toString())).value != null) {
                    error.append(((Http.Cookie)request.cookies.get((Object)new StringBuilder().append((String)Scope.COOKIE_PREFIX).append((String)"_ERRORS").toString())).value);
                }
                String errorData = URLEncoder.encode(error.toString(), "utf-8");
                Http.Cookie c = new Http.Cookie();
                c.value = errorData;
                c.name = Scope.COOKIE_PREFIX + "_ERRORS";
                request.cookies.put(Scope.COOKIE_PREFIX + "_ERRORS", c);
            }
            catch (Exception e) {
                throw new UnexpectedException("Error serialization problem", (Throwable)e);
            }
        }
    }

    protected static void addToResponse(Http.Response response, HttpResponse nettyResponse) {
        Map headers = response.headers;
        for (Map.Entry entry : headers.entrySet()) {
            Http.Header hd = (Http.Header)entry.getValue();
            for (String value : hd.values) {
                nettyResponse.setHeader((String)entry.getKey(), (Object)value);
            }
        }
        Map cookies = response.cookies;
        for (Http.Cookie cookie : cookies.values()) {
            CookieEncoder encoder = new CookieEncoder(true);
            DefaultCookie c = new DefaultCookie(cookie.name, cookie.value);
            c.setSecure(cookie.secure);
            c.setPath(cookie.path);
            if (cookie.domain != null) {
                c.setDomain(cookie.domain);
            }
            if (cookie.maxAge != null) {
                c.setMaxAge(cookie.maxAge.intValue());
            }
            encoder.addCookie((Cookie)c);
            nettyResponse.addHeader("Set-Cookie", (Object)encoder.encode());
        }
        if (!response.headers.containsKey("Cache-Control")) {
            nettyResponse.setHeader("Cache-Control", (Object)"no-cache");
        }
    }

    protected static void writeResponse(ChannelHandlerContext ctx, Http.Response response, HttpResponse nettyResponse, HttpRequest nettyRequest) {
        Logger.trace((String)"writeResponse: begin", (Object[])new Object[0]);
        byte[] content = null;
        boolean keepAlive = PlayHandler.isKeepAlive((HttpMessage)nettyRequest);
        content = nettyRequest.getMethod().equals((Object)HttpMethod.HEAD) ? new byte[]{} : response.out.toByteArray();
        ChannelBuffer buf = ChannelBuffers.copiedBuffer((byte[])content);
        nettyResponse.setContent(buf);
        if (keepAlive) {
            Logger.trace((String)("writeResponse: content length [" + response.out.size() + "]"), (Object[])new Object[0]);
            PlayHandler.setContentLength((HttpMessage)nettyResponse, response.out.size());
        }
        ChannelFuture f = ctx.getChannel().write((Object)nettyResponse);
        if (!keepAlive) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
        Logger.trace((String)"writeResponse: end", (Object[])new Object[0]);
    }

    /*
     * Unable to fully structure code
     */
    public static void copyResponse(ChannelHandlerContext ctx, Http.Request request, Http.Response response, HttpRequest nettyRequest) throws Exception {
        Logger.trace((String)"copyResponse: begin", (Object[])new Object[0]);
        nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.status));
        nettyResponse.setHeader("Server", (Object)PlayHandler.signature);
        if (response.contentType != null) {
            nettyResponse.setHeader("Content-Type", (Object)(response.contentType + (response.contentType.startsWith("text/") != false && response.contentType.contains("charset") == false ? "; charset=utf-8" : "")));
        } else {
            nettyResponse.setHeader("Content-Type", (Object)"text/plain; charset=utf-8");
        }
        PlayHandler.addToResponse(response, (HttpResponse)nettyResponse);
        obj = response.direct;
        file = null;
        is = null;
        if (obj instanceof File) {
            file = (File)obj;
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        }
        keepAlive = PlayHandler.isKeepAlive((HttpMessage)nettyRequest);
        if (file != null && file.isFile()) {
            nettyResponse = PlayHandler.addEtag(nettyRequest, (HttpResponse)nettyResponse, file);
            if (nettyResponse.getStatus().equals((Object)HttpResponseStatus.NOT_MODIFIED)) {
                ch = ctx.getChannel();
                writeFuture = ch.write((Object)nettyResponse);
                if (keepAlive) ** GOTO lbl51
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
            nettyResponse.setHeader("Content-Type", (Object)MimeTypes.getContentType((String)file.getName(), (String)"text/plain"));
            raf = new RandomAccessFile(file, "r");
            fileLength = raf.length();
            if (keepAlive) {
                Logger.trace((String)("file length is [" + fileLength + "]"), (Object[])new Object[0]);
                PlayHandler.setContentLength((HttpMessage)nettyResponse, fileLength);
            }
            ch = ctx.getChannel();
            writeFuture = ch.write((Object)nettyResponse);
            if (!nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
                writeFuture = ch.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
            }
            if (!keepAlive) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
            raf.close();
        } else if (is != null) {
            writeFuture = ctx.getChannel().write((Object)nettyResponse);
            if (!nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
                writeFuture = ctx.getChannel().write((Object)new ChunkedStream(is));
            }
            if (!keepAlive) {
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
        } else {
            PlayHandler.writeResponse(ctx, response, (HttpResponse)nettyResponse, nettyRequest);
        }
lbl51:
        // 5 sources

        Logger.trace((String)"copyResponse: end", (Object[])new Object[0]);
    }

    public static Http.Request parseRequest(ChannelHandlerContext ctx, HttpRequest nettyRequest) throws Exception {
        ChannelBuffer b;
        Logger.trace((String)"parseRequest: begin", (Object[])new Object[0]);
        Logger.trace((String)("parseRequest: URI = " + nettyRequest.getUri()), (Object[])new Object[0]);
        int index = nettyRequest.getUri().indexOf("?");
        String querystring = "";
        String path = URLDecoder.decode(nettyRequest.getUri(), "UTF-8");
        if (index != -1) {
            path = URLDecoder.decode(nettyRequest.getUri().substring(0, index), "UTF-8");
            querystring = nettyRequest.getUri().substring(index + 1);
        }
        Http.Request request = new Http.Request();
        request.remoteAddress = ((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getAddress().getHostAddress();
        request.method = nettyRequest.getMethod().getName();
        request.path = path;
        request.querystring = querystring;
        String contentType = nettyRequest.getHeader("Content-Type");
        request.contentType = contentType != null ? contentType.split(";")[0].trim().toLowerCase() : "text/html";
        if (nettyRequest.getHeader("X-HTTP-Method-Override") != null) {
            request.method = nettyRequest.getHeader("X-HTTP-Method-Override").intern();
        }
        if ((b = nettyRequest.getContent()) instanceof FileChannelBuffer) {
            FileChannelBuffer buffer = (FileChannelBuffer)b;
            Integer max = Integer.valueOf(Play.configuration.getProperty("play.module.netty.maxContentLength", "-1"));
            request.body = buffer.getInputStream();
            if (max != -1 && request.body.available() >= max) {
                request.body = new ByteArrayInputStream(new byte[0]);
            }
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)new ChannelBufferInputStream(b), (OutputStream)out);
            byte[] n = out.toByteArray();
            request.body = new ByteArrayInputStream(n);
        }
        request.url = nettyRequest.getUri();
        request.host = nettyRequest.getHeader("Host");
        if (request.host.contains(":")) {
            String[] host = request.host.split(":");
            request.port = Integer.parseInt(host[1]);
            request.domain = host[0];
        } else {
            request.port = 80;
            request.domain = request.host;
        }
        if (Play.configuration.containsKey("XForwardedSupport") && nettyRequest.getHeader("X-Forwarded-For") != null) {
            if (!Arrays.asList(Play.configuration.getProperty("XForwardedSupport", "127.0.0.1").split(",")).contains(request.remoteAddress)) {
                throw new RuntimeException("This proxy request is not authorized: " + request.remoteAddress);
            }
            request.secure = "https".equals(Play.configuration.get("XForwardedProto")) || "https".equals(nettyRequest.getHeader("X-Forwarded-Proto")) || "on".equals(nettyRequest.getHeader("X-Forwarded-Ssl"));
            if (Play.configuration.containsKey("XForwardedHost")) {
                request.host = (String)Play.configuration.get("XForwardedHost");
            } else if (nettyRequest.getHeader("X-Forwarded-Host") != null) {
                request.host = nettyRequest.getHeader("X-Forwarded-Host");
            }
            if (nettyRequest.getHeader("X-Forwarded-For") != null) {
                request.remoteAddress = nettyRequest.getHeader("X-Forwarded-For");
            }
        }
        PlayHandler.addToRequest(nettyRequest, request);
        request.resolveFormat();
        request._init();
        Logger.trace((String)"parseRequest: end", (Object[])new Object[0]);
        return request;
    }

    protected static void addToRequest(HttpRequest nettyRequest, Http.Request request) {
        Set cookies;
        for (String key : nettyRequest.getHeaderNames()) {
            Http.Header hd = new Http.Header();
            hd.name = key.toLowerCase();
            hd.values = new ArrayList();
            for (String next : nettyRequest.getHeaders(key)) {
                hd.values.add(next);
            }
            request.headers.put(hd.name, hd);
        }
        String value = nettyRequest.getHeader("Cookie");
        if (value != null && (cookies = new CookieDecoder().decode(value)) != null) {
            for (Cookie cookie : cookies) {
                Http.Cookie playCookie = new Http.Cookie();
                playCookie.name = cookie.getName();
                playCookie.path = cookie.getPath();
                playCookie.domain = cookie.getDomain();
                playCookie.secure = cookie.isSecure();
                playCookie.value = cookie.getValue();
                request.cookies.put(playCookie.name, playCookie);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getChannel().close();
    }

    public static void serve404(NotFound e, ChannelHandlerContext ctx, Http.Request request, HttpRequest nettyRequest) {
        Logger.trace((String)"serve404: begin", (Object[])new Object[0]);
        DefaultHttpResponse nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        nettyResponse.setHeader("Server", (Object)signature);
        nettyResponse.setHeader("Content-Type", (Object)"text/html");
        Map<String, Object> binding = PlayHandler.getBindingForErrors((Exception)((Object)e), false);
        String format = Http.Request.current().format;
        if (format == null || "XMLHttpRequest".equals(request.headers.get("x-requested-with")) && "html".equals(format)) {
            format = "txt";
        }
        nettyResponse.setHeader("Content-Type", (Object)MimeTypes.getContentType((String)("404." + format), (String)"text/plain"));
        String errorHtml = TemplateLoader.load((String)("errors/404." + format)).render(binding);
        try {
            ChannelBuffer buf = ChannelBuffers.copiedBuffer((byte[])errorHtml.getBytes("utf-8"));
            nettyResponse.setContent(buf);
            ChannelFuture writeFuture = ctx.getChannel().write((Object)nettyResponse);
            writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
        catch (UnsupportedEncodingException fex) {
            Logger.error((Throwable)fex, (String)"(utf-8 ?)", (Object[])new Object[0]);
        }
        Logger.trace((String)"serve404: end", (Object[])new Object[0]);
    }

    protected static Map<String, Object> getBindingForErrors(Exception e, boolean isError) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        if (!isError) {
            binding.put("result", e);
        } else {
            binding.put("exception", e);
        }
        binding.put("session", Scope.Session.current());
        binding.put("request", Http.Request.current());
        binding.put("flash", Scope.Flash.current());
        binding.put("params", Scope.Params.current());
        binding.put("play", new Play());
        try {
            binding.put("errors", Validation.errors());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return binding;
    }

    public static void serve500(Exception e, ChannelHandlerContext ctx, HttpRequest nettyRequest) {
        Logger.trace((String)"serve500: begin", (Object[])new Object[0]);
        DefaultHttpResponse nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        nettyResponse.setHeader("Server", (Object)signature);
        Http.Request request = Http.Request.current();
        Http.Response response = Http.Response.current();
        try {
            ChannelFuture writeFuture;
            ChannelBuffer buf;
            if (!(e instanceof PlayException)) {
                e = new UnexpectedException((Throwable)e);
            }
            try {
                Map cookies = response.cookies;
                for (Http.Cookie cookie : cookies.values()) {
                    CookieEncoder encoder = new CookieEncoder(true);
                    DefaultCookie c = new DefaultCookie(cookie.name, cookie.value);
                    c.setSecure(cookie.secure);
                    c.setPath(cookie.path);
                    if (cookie.domain != null) {
                        c.setDomain(cookie.domain);
                    }
                    if (cookie.maxAge != null) {
                        c.setMaxAge(cookie.maxAge.intValue());
                    }
                    encoder.addCookie((Cookie)c);
                    nettyResponse.addHeader("Set-Cookie", (Object)encoder.encode());
                }
            }
            catch (Exception exx) {
                Logger.error((Throwable)e, (String)"Trying to flush cookies", (Object[])new Object[0]);
            }
            Map<String, Object> binding = PlayHandler.getBindingForErrors(e, true);
            String format = request.format;
            if (format == null || "XMLHttpRequest".equals(request.headers.get("x-requested-with")) && "html".equals(format)) {
                format = "txt";
            }
            nettyResponse.setHeader("Content-Type", (Object)MimeTypes.getContentType((String)("500." + format), (String)"text/plain"));
            try {
                String errorHtml = TemplateLoader.load((String)("errors/500." + format)).render(binding);
                buf = ChannelBuffers.copiedBuffer((byte[])errorHtml.getBytes("utf-8"));
                nettyResponse.setContent(buf);
                writeFuture = ctx.getChannel().write((Object)nettyResponse);
                writeFuture.addListener(ChannelFutureListener.CLOSE);
                Logger.error((Throwable)e, (String)"Internal Server Error (500) for request %s", (Object[])new Object[]{request.method + " " + request.url});
            }
            catch (Throwable ex) {
                Logger.error((Throwable)e, (String)"Internal Server Error (500) for request %s", (Object[])new Object[]{request.method + " " + request.url});
                Logger.error((Throwable)ex, (String)"Error during the 500 response generation", (Object[])new Object[0]);
                try {
                    buf = ChannelBuffers.copiedBuffer((byte[])"Internal Error (check logs)".getBytes("utf-8"));
                    nettyResponse.setContent(buf);
                    writeFuture = ctx.getChannel().write((Object)nettyResponse);
                    writeFuture.addListener(ChannelFutureListener.CLOSE);
                }
                catch (UnsupportedEncodingException fex) {
                    Logger.error((Throwable)fex, (String)"(utf-8 ?)", (Object[])new Object[0]);
                }
            }
        }
        catch (Throwable exxx) {
            try {
                ChannelBuffer buf = ChannelBuffers.copiedBuffer((byte[])"Internal Error (check logs)".getBytes("utf-8"));
                nettyResponse.setContent(buf);
                ChannelFuture writeFuture = ctx.getChannel().write((Object)nettyResponse);
                writeFuture.addListener(ChannelFutureListener.CLOSE);
            }
            catch (Exception fex) {
                Logger.error((Throwable)fex, (String)"(utf-8 ?)", (Object[])new Object[0]);
            }
            if (exxx instanceof RuntimeException) {
                throw (RuntimeException)exxx;
            }
            throw new RuntimeException(exxx);
        }
        Logger.trace((String)"serve500: end", (Object[])new Object[0]);
    }

    public static void serveStatic(RenderStatic renderStatic, ChannelHandlerContext ctx, Http.Request request, Http.Response response, HttpRequest nettyRequest, MessageEvent e) {
        Logger.trace((String)"serveStatic: begin", (Object[])new Object[0]);
        DefaultHttpResponse nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.status));
        nettyResponse.setHeader("Server", (Object)signature);
        try {
            VirtualFile file = Play.getVirtualFile((String)renderStatic.file);
            if (file != null && file.exists() && file.isDirectory() && (file = file.child("index.html")) != null) {
                renderStatic.file = file.relativePath();
            }
            if (file == null || !file.exists()) {
                PlayHandler.serve404(new NotFound("The file " + renderStatic.file + " does not exist"), ctx, request, nettyRequest);
            } else {
                boolean raw = false;
                for (PlayPlugin plugin : Play.plugins) {
                    if (!plugin.serveStatic(file, Http.Request.current(), Http.Response.current())) continue;
                    raw = true;
                    break;
                }
                if (raw) {
                    PlayHandler.copyResponse(ctx, request, response, nettyRequest);
                } else {
                    File localFile = file.getRealFile();
                    boolean keepAlive = PlayHandler.isKeepAlive((HttpMessage)nettyRequest);
                    if ((nettyResponse = PlayHandler.addEtag(nettyRequest, (HttpResponse)nettyResponse, localFile)).getStatus().equals((Object)HttpResponseStatus.NOT_MODIFIED)) {
                        Channel ch = e.getChannel();
                        ChannelFuture writeFuture = ch.write((Object)nettyResponse);
                        if (!keepAlive) {
                            writeFuture.addListener(ChannelFutureListener.CLOSE);
                        }
                    } else {
                        RandomAccessFile raf = new RandomAccessFile(localFile, "r");
                        long fileLength = raf.length();
                        Logger.trace((String)("keep alive " + keepAlive), (Object[])new Object[0]);
                        Logger.trace((String)("content type " + MimeTypes.getContentType((String)localFile.getName(), (String)"text/plain")), (Object[])new Object[0]);
                        if (keepAlive && !nettyResponse.getStatus().equals((Object)HttpResponseStatus.NOT_MODIFIED)) {
                            Logger.trace((String)("file length " + fileLength), (Object[])new Object[0]);
                            PlayHandler.setContentLength((HttpMessage)nettyResponse, fileLength);
                        }
                        nettyResponse.setHeader("Content-Type", (Object)MimeTypes.getContentType((String)localFile.getName(), (String)"text/plain"));
                        Channel ch = e.getChannel();
                        ch.write((Object)nettyResponse);
                        ChannelFuture writeFuture = ch.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
                        if (!keepAlive) {
                            writeFuture.addListener(ChannelFutureListener.CLOSE);
                        }
                        raf.close();
                    }
                }
            }
        }
        catch (Exception ez) {
            Logger.error((Throwable)ez, (String)"serveStatic for request %s", (Object[])new Object[]{request.method + " " + request.url});
            try {
                ChannelBuffer buf = ChannelBuffers.copiedBuffer((byte[])"Internal Error (check logs)".getBytes("utf-8"));
                nettyResponse.setContent(buf);
                ChannelFuture future = ctx.getChannel().write((Object)nettyResponse);
                future.addListener(ChannelFutureListener.CLOSE);
            }
            catch (Exception ex) {
                Logger.error((Throwable)ez, (String)"serveStatic for request %s", (Object[])new Object[]{request.method + " " + request.url});
            }
        }
        Logger.trace((String)"serveStatic: end", (Object[])new Object[0]);
    }

    public static boolean isModified(String etag, long last, HttpRequest nettyRequest) {
        String ifModifiedSince;
        if (nettyRequest.containsHeader("If-None-Match")) {
            String browserEtag = nettyRequest.getHeader("If-None-Match");
            return !browserEtag.equals(etag);
        }
        if (nettyRequest.containsHeader("If-Modified-Since") && !StringUtils.isEmpty((String)(ifModifiedSince = nettyRequest.getHeader("If-Modified-Since")))) {
            try {
                Date browserDate = Utils.getHttpDateFormatter().parse(ifModifiedSince);
                if (browserDate.getTime() >= last) {
                    return false;
                }
            }
            catch (ParseException ex) {
                Logger.warn((String)"Can't parse HTTP date", (Object[])new Object[]{ex});
            }
            return true;
        }
        return true;
    }

    private static HttpResponse addEtag(HttpRequest nettyRequest, HttpResponse httpResponse, File file) {
        if (Play.mode == Play.Mode.DEV) {
            httpResponse.setHeader("Cache-Control", (Object)"no-cache");
        } else {
            String maxAge = Play.configuration.getProperty("http.cacheControl", "3600");
            if (maxAge.equals("0")) {
                httpResponse.setHeader("Cache-Control", (Object)"no-cache");
            } else {
                httpResponse.setHeader("Cache-Control", (Object)("max-age=" + maxAge));
            }
        }
        boolean useEtag = Play.configuration.getProperty("http.useETag", "true").equals("true");
        long last = file.lastModified();
        String etag = "\"" + last + "-" + file.hashCode() + "\"";
        if (!PlayHandler.isModified(etag, last, nettyRequest)) {
            if (nettyRequest.getMethod().equals((Object)HttpMethod.GET)) {
                httpResponse.setStatus(HttpResponseStatus.NOT_MODIFIED);
            }
            if (useEtag) {
                httpResponse.setHeader("ETag", (Object)etag);
            }
        } else {
            httpResponse.setHeader("Last-Modified", (Object)Utils.getHttpDateFormatter().format(new Date(last)));
            if (useEtag) {
                httpResponse.setHeader("ETag", (Object)etag);
            }
        }
        return httpResponse;
    }

    public static boolean isKeepAlive(HttpMessage message) {
        return HttpHeaders.isKeepAlive((HttpMessage)message);
    }

    public static void setContentLength(HttpMessage message, long contentLength) {
        message.setHeader("Content-Length", (Object)String.valueOf(contentLength));
    }

    public class NettyInvocation
    extends Invoker.Invocation {
        private final ChannelHandlerContext ctx;
        private final Http.Request request;
        private final Http.Response response;
        private final HttpRequest nettyRequest;
        private final MessageEvent e;

        public NettyInvocation(Http.Request request, Http.Response response, ChannelHandlerContext ctx, HttpRequest nettyRequest, MessageEvent e) {
            this.ctx = ctx;
            this.request = request;
            this.response = response;
            this.nettyRequest = nettyRequest;
            this.e = e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean init() {
            Logger.trace((String)"init: begin", (Object[])new Object[0]);
            Http.Request.current.set(this.request);
            Http.Response.current.set(this.response);
            if (!this.request.path.equals("/favicon.ico")) {
                super.init();
            }
            if (Play.mode == Play.Mode.PROD && staticPathsCache.containsKey(this.request.path)) {
                RenderStatic rs = null;
                Map map = staticPathsCache;
                synchronized (map) {
                    rs = (RenderStatic)((Object)staticPathsCache.get(this.request.path));
                }
                PlayHandler.serveStatic(rs, this.ctx, this.request, this.response, this.nettyRequest, this.e);
                Logger.trace((String)"init: end false", (Object[])new Object[0]);
                return false;
            }
            try {
                Router.routeOnlyStatic((Http.Request)this.request);
            }
            catch (NotFound e) {
                PlayHandler.serve404(e, this.ctx, this.request, this.nettyRequest);
                Logger.trace((String)"init: end false", (Object[])new Object[0]);
                return false;
            }
            catch (RenderStatic e) {
                if (Play.mode == Play.Mode.PROD) {
                    Map map = staticPathsCache;
                    synchronized (map) {
                        staticPathsCache.put(this.request.path, e);
                    }
                }
                PlayHandler.serveStatic(e, this.ctx, this.request, this.response, this.nettyRequest, this.e);
                Logger.trace((String)"init: end false", (Object[])new Object[0]);
                return false;
            }
            Logger.trace((String)"init: end true", (Object[])new Object[0]);
            return true;
        }

        public void run() {
            try {
                Logger.trace((String)"run: begin", (Object[])new Object[0]);
                super.run();
            }
            catch (Exception e) {
                PlayHandler.serve500(e, this.ctx, this.nettyRequest);
            }
            Logger.trace((String)"run: end", (Object[])new Object[0]);
        }

        public void execute() throws Exception {
            if (!this.ctx.getChannel().isConnected()) {
                try {
                    this.ctx.getChannel().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            ActionInvoker.invoke((Http.Request)this.request, (Http.Response)this.response);
            PlayHandler.this.saveExceededSizeError(this.nettyRequest, this.request, this.response);
            PlayHandler.copyResponse(this.ctx, this.request, this.response, this.nettyRequest);
            Logger.trace((String)"execute: end", (Object[])new Object[0]);
        }
    }
}

