/*
 * Decompiled with CFR 0.152.
 */
package play.modules.netty;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import play.Logger;
import play.Play;
import play.modules.netty.HttpServerPipelineFactory;

public class Server {
    public Server() {
        Properties p = Play.configuration;
        int httpPort = Integer.parseInt(p.getProperty("http.port", "9000"));
        InetAddress address = null;
        if (System.getProperties().containsKey("http.port")) {
            httpPort = Integer.parseInt(System.getProperty("http.port"));
        }
        try {
            if (p.getProperty("http.address") != null) {
                address = InetAddress.getByName(p.getProperty("http.address"));
            }
            if (System.getProperties().containsKey("http.address")) {
                address = InetAddress.getByName(System.getProperty("http.address"));
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Could not understand http.address", (Object[])new Object[0]);
            System.exit(-1);
        }
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpServerPipelineFactory());
        bootstrap.bind((SocketAddress)new InetSocketAddress(address, httpPort));
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        try {
            if (Play.mode == Play.Mode.DEV) {
                if (address == null) {
                    Logger.info((String)"Listening for HTTP on port %s (Waiting a first request to start) ...", (Object[])new Object[]{httpPort});
                } else {
                    Logger.info((String)"Listening for HTTP at %2$s:%1$s (Waiting a first request to start) ...", (Object[])new Object[]{httpPort, address});
                }
            } else if (address == null) {
                Logger.info((String)"Listening for HTTP on port %s ...", (Object[])new Object[]{httpPort});
            } else {
                Logger.info((String)"Listening for HTTP at %2$s:%1$s  ...", (Object[])new Object[]{httpPort, address});
            }
        }
        catch (ChannelException e) {
            Logger.error((String)("Could not bind on port " + httpPort), (Object[])new Object[]{e});
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        if (System.getProperty("precompile") == null) {
            new Server();
        } else {
            Logger.info((String)"Done.", (Object[])new Object[0]);
        }
    }
}

