/*
 * Decompiled with CFR 0.152.
 */
package play.modules.netty;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import play.Play;
import play.modules.netty.FileChannelBuffer;

public class StreamChunkAggregator
extends SimpleChannelUpstreamHandler {
    private volatile HttpMessage currentMessage;
    private volatile OutputStream out;
    private final int maxContentLength;
    private volatile File file;

    public StreamChunkAggregator(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpChunk)) {
            ctx.sendUpstream((ChannelEvent)e);
            return;
        }
        HttpMessage currentMessage = this.currentMessage;
        File localFile = this.file;
        if (currentMessage == null) {
            HttpMessage m = (HttpMessage)msg;
            if (m.isChunked()) {
                String localName = UUID.randomUUID().toString();
                List encodings = m.getHeaders("Transfer-Encoding");
                encodings.remove("chunked");
                if (encodings.isEmpty()) {
                    m.removeHeader("Transfer-Encoding");
                }
                this.currentMessage = m;
                this.file = new File(Play.tmpDir, localName);
                this.out = new FileOutputStream(this.file, true);
            } else {
                ctx.sendUpstream((ChannelEvent)e);
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            if (this.maxContentLength != -1 && localFile.length() > (long)(this.maxContentLength - chunk.getContent().readableBytes())) {
                currentMessage.setHeader("Warning", (Object)"play.module.netty.content.length.exceeded");
            } else {
                IOUtils.copyLarge((InputStream)new ChannelBufferInputStream(chunk.getContent()), (OutputStream)this.out);
                if (chunk.isLast()) {
                    this.out.flush();
                    this.out.close();
                    currentMessage.setHeader("Content-Length", (Object)String.valueOf(localFile.length()));
                    currentMessage.setContent((ChannelBuffer)new FileChannelBuffer(localFile));
                    this.out = null;
                    this.currentMessage = null;
                    this.file = null;
                    Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)currentMessage, (SocketAddress)e.getRemoteAddress());
                }
            }
        }
    }
}

