/*
 * Decompiled with CFR 0.152.
 */
package play.modules.netty;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.SocketAddress;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import play.Play;
import play.modules.netty.FileChannelBuffer;

public class StreamChunkAggregator
extends SimpleChannelUpstreamHandler {
    private volatile HttpMessage currentMessage;
    private volatile String name;
    private final int maxContentLength;

    public StreamChunkAggregator(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpChunk)) {
            ctx.sendUpstream((ChannelEvent)e);
            return;
        }
        String localFile = this.name;
        HttpMessage currentMessage = this.currentMessage;
        if (currentMessage == null) {
            HttpMessage m = (HttpMessage)msg;
            if (m.isChunked()) {
                String localName = UUID.randomUUID().toString();
                List encodings = m.getHeaders("Transfer-Encoding");
                encodings.remove("chunked");
                if (encodings.isEmpty()) {
                    m.removeHeader("Transfer-Encoding");
                }
                this.currentMessage = m;
                this.name = localName;
            } else {
                ctx.sendUpstream((ChannelEvent)e);
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            File file = new File(Play.tmpDir, this.name);
            if (this.maxContentLength != -1 && file.length() > (long)(this.maxContentLength - chunk.getContent().readableBytes())) {
                currentMessage.setHeader("Content-Length", (Object)this.maxContentLength);
                currentMessage.setHeader("Warning", (Object)"play.netty.content.length.exceeded");
                return;
            }
            FileWriter fstream = new FileWriter(file, true);
            BufferedWriter out = new BufferedWriter(fstream);
            IOUtils.copy((InputStream)new ByteArrayInputStream(chunk.getContent().array()), (Writer)out);
            out.flush();
            out.close();
            fstream.close();
            if (chunk.isLast()) {
                currentMessage.setHeader("Content-Length", (Object)String.valueOf(localFile.length()));
                currentMessage.setContent((ChannelBuffer)new FileChannelBuffer(file));
                this.name = null;
                this.currentMessage = null;
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)currentMessage, (SocketAddress)e.getRemoteAddress());
            }
        }
    }
}

