/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.DirectBufferPool;
import org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.jboss.netty.channel.socket.nio.NioProviderMetadata;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.IoWorkerRunnable;
import org.jboss.netty.util.internal.LinkedTransferQueue;
import org.jboss.netty.util.internal.NonReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioWorker
implements Runnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioWorker.class);
    private static final int CONSTRAINT_LEVEL = NioProviderMetadata.CONSTRAINT_LEVEL;
    static final int CLEANUP_INTERVAL = 256;
    private final int bossId;
    private final int id;
    private final Executor executor;
    private boolean started;
    private volatile Thread thread;
    volatile Selector selector;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final ReadWriteLock selectorGuard = new ReentrantReadWriteLock();
    private final Object startStopLock = new Object();
    private final Queue<Runnable> registerTaskQueue = new LinkedTransferQueue<Runnable>();
    private final Queue<Runnable> writeTaskQueue = new LinkedTransferQueue<Runnable>();
    private volatile int cancelledKeys;

    NioWorker(int bossId, int id, Executor executor) {
        this.bossId = bossId;
        this.id = id;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(NioSocketChannel channel, ChannelFuture future) {
        Selector selector;
        boolean server = !(channel instanceof NioClientSocketChannel);
        RegisterTask registerTask = new RegisterTask(channel, future, server);
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                try {
                    this.selector = selector = Selector.open();
                }
                catch (Throwable t) {
                    throw new ChannelException("Failed to create a selector.", t);
                }
                String threadName = (server ? "New I/O server worker #" : "New I/O client worker #") + this.bossId + '-' + this.id;
                boolean success = false;
                try {
                    this.executor.execute(new IoWorkerRunnable(new ThreadRenamingRunnable(this, threadName)));
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            selector.close();
                        }
                        catch (Throwable t) {
                            logger.warn("Failed to close a selector.", t);
                        }
                        selector = null;
                        this.selector = null;
                    }
                }
            }
            selector = this.selector;
            assert (selector != null && selector.isOpen());
            this.started = true;
            boolean offered = this.registerTaskQueue.offer(registerTask);
            assert (offered);
        }
        if (this.wakenUp.compareAndSet(false, true)) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        boolean shutdown = false;
        Selector selector = this.selector;
        while (true) {
            this.wakenUp.set(false);
            if (CONSTRAINT_LEVEL != 0) {
                this.selectorGuard.writeLock().lock();
                this.selectorGuard.writeLock().unlock();
            }
            try {
                selector.select(500L);
                if (this.wakenUp.get()) {
                    selector.wakeup();
                }
                this.cancelledKeys = 0;
                this.processRegisterTaskQueue();
                this.processWriteTaskQueue();
                this.processSelectedKeys(selector.selectedKeys());
                if (selector.keys().isEmpty()) {
                    if (shutdown || this.executor instanceof ExecutorService && ((ExecutorService)this.executor).isShutdown()) {
                        Object object = this.startStopLock;
                        synchronized (object) {
                            if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                this.started = false;
                                try {
                                    selector.close();
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to close a selector.", e);
                                }
                                finally {
                                    this.selector = null;
                                }
                                break;
                            }
                            shutdown = false;
                            continue;
                        }
                    }
                    shutdown = true;
                    continue;
                }
                shutdown = false;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void processRegisterTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.registerTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processWriteTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.writeTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processSelectedKeys(Set<SelectionKey> selectedKeys) throws IOException {
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if (((readyOps & 1) != 0 || readyOps == 0) && !this.read(k)) continue;
                if ((readyOps & 4) != 0) {
                    this.write((NioSocketChannel)k.attachment());
                }
            }
            catch (CancelledKeyException e) {
                this.close(k);
            }
            if (!this.cleanUpCancelledKeys()) continue;
            break;
        }
    }

    private boolean cleanUpCancelledKeys() throws IOException {
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.selector.selectNow();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(SelectionKey k) {
        SocketChannel nioch = (SocketChannel)k.channel();
        NioSocketChannel channel = (NioSocketChannel)k.attachment();
        NioSocketChannelConfig cfg = channel.getConfig();
        ReceiveBufferSizePredictor predictor = cfg.getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = cfg.getBufferFactory();
        ChannelBuffer buffer = bufferFactory.getBuffer(predictor.nextReceiveBufferSize());
        boolean fromPool = !buffer.isDirect();
        ByteBuffer directBuffer = fromPool ? DirectBufferPool.acquire(buffer.writableBytes()) : buffer.toByteBuffer();
        int ret = 0;
        int readBytes = 0;
        boolean failure = true;
        try {
            while ((ret = nioch.read(directBuffer)) > 0) {
                readBytes += ret;
                if (directBuffer.hasRemaining()) continue;
            }
            failure = false;
        }
        catch (ClosedChannelException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        finally {
            if (fromPool) {
                directBuffer.flip();
                buffer.writeBytes(directBuffer);
                DirectBufferPool.release(directBuffer);
            } else {
                buffer.writerIndex(buffer.writerIndex() + readBytes);
            }
        }
        if (readBytes > 0) {
            predictor.previousReceiveBufferSize(readBytes);
            Channels.fireMessageReceived(channel, (Object)buffer);
        }
        if (ret < 0 || failure) {
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    private void close(SelectionKey k) {
        NioSocketChannel ch = (NioSocketChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(NioSocketChannel channel) {
        int writtenBytes;
        boolean removeOpWrite;
        boolean addOpWrite;
        boolean open;
        block30: {
            if (!channel.isConnected()) {
                this.cleanUpWriteBuffer(channel);
                return;
            }
            NonReentrantLock writeLock = channel.writeLock;
            if (!writeLock.tryLock()) {
                this.rescheduleWrite(channel);
                return;
            }
            Queue<MessageEvent> writeBuffer = channel.writeBuffer;
            int writeSpinCount = channel.getConfig().getWriteSpinCount();
            open = true;
            addOpWrite = false;
            removeOpWrite = false;
            writtenBytes = 0;
            block12: while (true) {
                while (true) {
                    ByteBuffer buf;
                    MessageEvent evt;
                    if ((evt = channel.currentWriteEvent) == null) {
                        channel.currentWriteEvent = evt = writeBuffer.poll();
                        if (evt == null) {
                            removeOpWrite = true;
                            break block30;
                        }
                        ChannelBuffer origBuf = (ChannelBuffer)evt.getMessage();
                        if (origBuf.isDirect()) {
                            channel.currentWriteBuffer = buf = origBuf.toByteBuffer();
                            channel.currentWriteBufferIsPooled = false;
                        } else {
                            channel.currentWriteBuffer = buf = DirectBufferPool.acquire(origBuf);
                            channel.currentWriteBufferIsPooled = true;
                        }
                    } else {
                        buf = channel.currentWriteBuffer;
                    }
                    try {
                        for (int i = writeSpinCount; i > 0; --i) {
                            int localWrittenBytes = channel.socket.write(buf);
                            if (localWrittenBytes == 0) continue;
                            writtenBytes += localWrittenBytes;
                            break;
                        }
                        if (!buf.hasRemaining()) {
                            if (channel.currentWriteBufferIsPooled) {
                                DirectBufferPool.release(buf);
                            }
                            ChannelFuture future = evt.getFuture();
                            channel.currentWriteEvent = null;
                            channel.currentWriteBuffer = null;
                            evt = null;
                            buf = null;
                            future.setSuccess();
                            continue block12;
                        }
                        addOpWrite = true;
                        break block30;
                    }
                    catch (AsynchronousCloseException e) {
                        continue;
                    }
                    catch (Throwable t) {
                        if (channel.currentWriteBufferIsPooled) {
                            DirectBufferPool.release(buf);
                        }
                        ChannelFuture future = evt.getFuture();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        buf = null;
                        evt = null;
                        future.setFailure(t);
                        Channels.fireExceptionCaught(channel, t);
                        if (!(t instanceof IOException)) continue;
                        open = false;
                        this.close(channel, Channels.succeededFuture(channel));
                        continue;
                    }
                    break;
                }
                break;
            }
            finally {
                writeLock.unlock();
            }
        }
        Channels.fireWriteComplete(channel, writtenBytes);
        if (open) {
            Object object;
            if (addOpWrite) {
                object = channel.interestOpsLock;
                synchronized (object) {
                    int interestOps = channel.getRawInterestOps();
                    if ((interestOps & 4) == 0) {
                        this.setInterestOps0(channel, interestOps |= 4);
                    }
                }
            }
            if (removeOpWrite) {
                object = channel.interestOpsLock;
                synchronized (object) {
                    int interestOps = channel.getRawInterestOps();
                    if ((interestOps & 4) != 0) {
                        this.setInterestOps0(channel, interestOps &= 0xFFFFFFFB);
                    }
                }
            }
        }
    }

    private void rescheduleWrite(NioSocketChannel channel) {
        Selector workerSelector;
        Thread currentThread = Thread.currentThread();
        if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
            boolean offered = this.writeTaskQueue.offer(channel.writeTask);
            assert (offered);
        }
        if ((!(channel instanceof NioAcceptedSocketChannel) || ((NioAcceptedSocketChannel)channel).bossThread != currentThread) && (workerSelector = this.selector) != null && this.wakenUp.compareAndSet(false, true)) {
            workerSelector.wakeup();
        }
    }

    void close(NioSocketChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            ++this.cancelledKeys;
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                this.cleanUpWriteBuffer(channel);
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpWriteBuffer(NioSocketChannel channel) {
        boolean fireExceptionCaught;
        Exception cause;
        block9: {
            cause = null;
            fireExceptionCaught = false;
            channel.writeLock.lock();
            try {
                Queue<MessageEvent> writeBuffer;
                MessageEvent evt = channel.currentWriteEvent;
                ByteBuffer buf = channel.currentWriteBuffer;
                if (evt != null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                    if (channel.currentWriteBufferIsPooled) {
                        DirectBufferPool.release(buf);
                    }
                    ChannelFuture future = evt.getFuture();
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    future.setFailure(cause);
                    fireExceptionCaught = true;
                }
                if ((writeBuffer = channel.writeBuffer).isEmpty()) break block9;
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                }
                while ((evt = writeBuffer.poll()) != null) {
                    evt.getFuture().setFailure(cause);
                    fireExceptionCaught = true;
                }
            }
            finally {
                channel.writeLock.unlock();
            }
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(channel, (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterestOps(NioSocketChannel channel, ChannelFuture future, int interestOps) {
        interestOps &= 0xFFFFFFFB;
        interestOps |= channel.getRawInterestOps() & 4;
        try {
            boolean changed;
            Object object = channel.interestOpsLock;
            synchronized (object) {
                changed = this.setInterestOps0(channel, interestOps);
            }
            future.setSuccess();
            if (changed) {
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (CancelledKeyException e) {
            ClosedChannelException cce = new ClosedChannelException();
            future.setFailure(cce);
            Channels.fireExceptionCaught(channel, (Throwable)cce);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setInterestOps0(NioSocketChannel channel, int interestOps) {
        Selector selector = this.selector;
        SelectionKey key = channel.socket.keyFor(selector);
        if (key == null || selector == null) {
            channel.setRawInterestOpsNow(interestOps);
            return false;
        }
        switch (CONSTRAINT_LEVEL) {
            case 0: {
                if (channel.getRawInterestOps() == interestOps) break;
                key.interestOps(interestOps);
                if (Thread.currentThread() != this.thread && this.wakenUp.compareAndSet(false, true)) {
                    selector.wakeup();
                }
                channel.setRawInterestOpsNow(interestOps);
                return true;
            }
            case 1: 
            case 2: {
                if (channel.getRawInterestOps() == interestOps) break;
                if (Thread.currentThread() == this.thread) {
                    key.interestOps(interestOps);
                    channel.setRawInterestOpsNow(interestOps);
                    return true;
                }
                this.selectorGuard.readLock().lock();
                try {
                    if (this.wakenUp.compareAndSet(false, true)) {
                        selector.wakeup();
                    }
                    key.interestOps(interestOps);
                    channel.setRawInterestOpsNow(interestOps);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.selectorGuard.readLock().unlock();
                }
            }
            default: {
                throw new Error();
            }
        }
        return false;
    }

    private final class RegisterTask
    implements Runnable {
        private final NioSocketChannel channel;
        private final ChannelFuture future;
        private final boolean server;

        RegisterTask(NioSocketChannel channel, ChannelFuture future, boolean server) {
            this.channel = channel;
            this.future = future;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InetSocketAddress remoteAddress;
            InetSocketAddress localAddress;
            block12: {
                localAddress = this.channel.getLocalAddress();
                remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null || remoteAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    if (this.server) {
                        this.channel.socket.configureBlocking(false);
                    }
                    Object object = this.channel.interestOpsLock;
                    synchronized (object) {
                        this.channel.socket.register(NioWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                    }
                    if (this.future != null) {
                        this.channel.setConnected();
                        this.future.setSuccess();
                    }
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block12;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
            if (!this.server) {
                if (!((NioClientSocketChannel)this.channel).boundManually) {
                    Channels.fireChannelBound(this.channel, (SocketAddress)localAddress);
                }
                Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
            }
        }
    }
}

