/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.queue;

import java.util.Queue;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelDownstreamHandler;
import org.jboss.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWriteHandler
extends SimpleChannelDownstreamHandler {
    private final Queue<MessageEvent> queue;
    private volatile ChannelHandlerContext ctx;

    public BufferedWriteHandler() {
        this(new LinkedTransferQueue<MessageEvent>());
    }

    public BufferedWriteHandler(Queue<MessageEvent> queue) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        this.queue = queue;
    }

    protected Queue<MessageEvent> getQueue() {
        return this.queue;
    }

    public void flush() {
        MessageEvent e;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        Queue<MessageEvent> queue = this.getQueue();
        while ((e = queue.poll()) != null) {
            ctx.sendDownstream(e);
        }
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.ctx == null) {
            this.ctx = ctx;
        } else assert (this.ctx == ctx);
        this.getQueue().add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            this.flush();
            Object var4_3 = null;
            ctx.sendDownstream(e);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.sendDownstream(e);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            this.flush();
            Object var4_3 = null;
            ctx.sendDownstream(e);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.sendDownstream(e);
            throw throwable;
        }
    }
}

