/*
 * Decompiled with CFR 0.152.
 */
package play.modules.objectify;

import com.googlecode.objectify.Key;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Id;
import play.data.binding.BeanWrapper;
import play.data.binding.Binder;
import play.exceptions.UnexpectedException;
import play.modules.objectify.ObjectifyModel;
import play.modules.objectify.ObjectifyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectifyBinder {
    public Object bind(String name, Class clazz, Type type, Map<String, String[]> params) {
        if (ObjectifyModel.class.isAssignableFrom(clazz)) {
            String idKey = name + ".id";
            if (params.containsKey(idKey) && params.get(idKey).length > 0 && params.get(idKey)[0] != null && params.get(idKey)[0].trim().length() > 0) {
                String rawId = params.get(idKey)[0];
                params.remove(idKey);
                Class idType = ObjectifyBinder.findKeyType(clazz);
                Object instance = this.find(clazz, rawId, idType);
                if (instance != null) {
                    return this.edit(instance, name, params);
                }
            }
            return this.create(clazz, name, params);
        }
        return null;
    }

    public <T extends ObjectifyModel> T find(Class<T> clazz, String rawId, Class idType) {
        Key key = null;
        if (ObjectifyBinder.isNumeric(rawId)) {
            key = new Key(clazz, Long.parseLong(rawId));
        } else if (idType.equals(String.class)) {
            key = new Key(clazz, rawId);
        }
        ObjectifyModel instance = null;
        if (key != null) {
            instance = (ObjectifyModel)ObjectifyService.find(key, false);
        }
        if (instance == null) {
            try {
                key = ObjectifyService.getKey((Object)rawId);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            instance = (ObjectifyModel)ObjectifyService.find(key, false);
        }
        return (T)instance;
    }

    public <T extends ObjectifyModel> T create(Class clazz, String name, Map<String, String[]> params) {
        ObjectifyModel instance = (ObjectifyModel)ObjectifyService.instantiate(clazz);
        return (T)this.edit(instance, name, params);
    }

    public <T> T edit(T instance, String name, Map<String, String[]> params) {
        try {
            BeanWrapper bw = new BeanWrapper(instance.getClass());
            HashSet fields = new HashSet();
            Class<?> clazz = instance.getClass();
            while (!clazz.equals(Object.class)) {
                Collections.addAll(fields, clazz.getDeclaredFields());
                clazz = clazz.getSuperclass();
            }
            for (Field field : fields) {
                boolean many;
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                String fieldName = field.getName();
                String fieldPath = name + "." + fieldName;
                String[] fieldValues = params.get(fieldPath);
                boolean embedded = field.getAnnotation(Embedded.class) != null;
                boolean bl = many = Collection.class.isAssignableFrom(fieldType) || fieldType.isArray();
                if (Key.class.isAssignableFrom(fieldType)) {
                    if (fieldValues == null || fieldValues.length <= 0) continue;
                    if (!fieldValues[0].equals("")) {
                        params.remove(fieldPath);
                        String rawId = fieldValues[0];
                        Key key = ObjectifyService.getKey((Object)rawId);
                        bw.set(fieldName, instance, key);
                        continue;
                    }
                    bw.set(fieldName, instance, null);
                    params.remove(fieldPath);
                    continue;
                }
                if (many) {
                    if (fieldValues == null && ObjectifyBinder.getParamsByKeyPrefix(params, fieldPath + "[0]").size() == 0) {
                        bw.set(fieldName, instance, null);
                        continue;
                    }
                    Class fieldManyRawType = ObjectifyBinder.getCollectionFieldRawType(field);
                    if (fieldManyRawType != null) {
                        Object collectionOrArray;
                        Collection collection;
                        if (Key.class.isAssignableFrom(fieldManyRawType)) {
                            collection = ObjectifyBinder.newCollection(field, fieldPath);
                            for (String rawId : fieldValues) {
                                Key key = ObjectifyService.getKey((Object)rawId);
                                collection.add(key);
                            }
                            collectionOrArray = ObjectifyBinder.convertToArrayIfRequired(fieldType, fieldManyRawType, collection);
                            bw.set(fieldName, instance, collectionOrArray);
                            params.remove(fieldPath);
                            continue;
                        }
                        if (embedded) {
                            String fieldPathNested;
                            Map<String, String[]> paramsNested;
                            int i = 0;
                            Collection collection2 = ObjectifyBinder.newCollection(field, fieldPath);
                            while ((paramsNested = ObjectifyBinder.getParamsByKeyPrefix(params, fieldPathNested = fieldPath + "[" + i + "]")).size() > 0) {
                                String fieldValue = ObjectifyService.instantiate(fieldManyRawType);
                                fieldValue = this.edit(fieldValue, fieldPathNested, paramsNested);
                                collection2.add(fieldValue);
                                ++i;
                            }
                            Object collectionOrArray2 = ObjectifyBinder.convertToArrayIfRequired(fieldType, fieldManyRawType, collection2);
                            bw.set(fieldName, instance, collectionOrArray2);
                            continue;
                        }
                        if (this.isSimpleType(fieldManyRawType)) {
                            collection = ObjectifyBinder.newCollection(field, fieldPath);
                            for (String fieldValue : fieldValues) {
                                Object convertedFieldValue = Binder.directBind((String)fieldValue, (Class)fieldManyRawType);
                                collection.add(convertedFieldValue);
                            }
                            collectionOrArray = ObjectifyBinder.convertToArrayIfRequired(fieldType, fieldManyRawType, collection);
                            bw.set(fieldName, instance, collectionOrArray);
                            params.remove(fieldPath);
                            continue;
                        }
                        throw new UnexpectedException("Unable to bind: " + instance.getClass() + ", " + fieldPath + " is a neither Key<T>, @Embedded, Enum or simple collection");
                    }
                    throw new UnexpectedException("Unable to bind: " + instance.getClass() + ", " + fieldPath + " is a non-parameterized collection");
                }
                if (!embedded) continue;
                Object fieldValue = ObjectifyService.instantiate(fieldType);
                fieldValue = this.edit(fieldValue, fieldPath, params);
                bw.set(fieldName, instance, fieldValue);
            }
            bw.bind(name, instance.getClass(), params, "", instance);
            return instance;
        }
        catch (Exception e) {
            throw new UnexpectedException("Unable to bind: " + instance.getClass() + ", " + e.getMessage(), (Throwable)e);
        }
    }

    public static Collection newCollection(Field field, String fieldPath) {
        Class<?> type = field.getType();
        if (List.class.isAssignableFrom(type) || type.isArray()) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(type)) {
            return new HashSet();
        }
        throw new UnexpectedException("Unable to instantiate Collection as it is neither List, Set or Array: " + fieldPath + ", " + type.getName());
    }

    public static Object convertToArrayIfRequired(Class fieldType, Class rawType, Collection collection) {
        if (fieldType.isArray()) {
            Object[] array = (Object[])Array.newInstance(rawType, collection.size());
            return collection.toArray(array);
        }
        return collection;
    }

    public static Class getCollectionFieldRawType(Field field) {
        ParameterizedType genericType;
        Type[] args;
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (args = (genericType = (ParameterizedType)field.getGenericType()).getActualTypeArguments()) != null && args.length > 0 && args[0] != null) {
            return (Class)args[0];
        }
        return null;
    }

    public static Map<String, String[]> getParamsByKeyPrefix(Map<String, String[]> params, String keyPrefix) {
        HashMap<String, String[]> newParams = new HashMap<String, String[]>();
        Set<Map.Entry<String, String[]>> entries = params.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (!key.startsWith(keyPrefix)) continue;
            newParams.put(key, value);
        }
        return newParams;
    }

    public static Class findKeyType(Class clazz) {
        try {
            while (!clazz.equals(Object.class)) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Id.class)) continue;
                    field.setAccessible(true);
                    return field.getType();
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new UnexpectedException("Error while determining the @Id for an object of type: " + clazz);
        }
        return null;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isSimpleType(Class type) {
        return String.class.equals((Object)type) || Number.class.isAssignableFrom(type) || type.isPrimitive() || type.isEnum() || Date.class.equals((Object)type) || Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type);
    }
}

