/*
 * Decompiled with CFR 0.152.
 */
package play.modules.objectify;

import com.googlecode.objectify.Key;
import java.lang.reflect.Field;
import play.modules.objectify.ObjectifyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectifyModel {
    public <T extends ObjectifyModel> Key<T> getKey() {
        return ObjectifyService.getKey((Object)this);
    }

    public <T extends ObjectifyModel> Key<T> key() {
        return ObjectifyService.key((Object)this);
    }

    public String getKeyStr() {
        return ObjectifyService.getKeyStr(this);
    }

    public String keyStr() {
        return ObjectifyService.keyStr(this);
    }

    public String str() {
        return ObjectifyService.keyStr(this);
    }

    public <R> R fetch(String str) {
        String idOrKeyProperty;
        String rawKind;
        int colon = str.indexOf(":");
        if (colon == -1) {
            if (str.endsWith("Id")) {
                rawKind = str.substring(0, str.length() - 2);
                idOrKeyProperty = str;
            } else if (str.endsWith("Key")) {
                rawKind = str.substring(0, str.length() - 3);
                idOrKeyProperty = str;
            } else {
                rawKind = str;
                idOrKeyProperty = str;
            }
        } else {
            idOrKeyProperty = str.substring(0, colon);
            rawKind = str.substring(colon + 1);
        }
        return this.fetch(idOrKeyProperty, rawKind);
    }

    public <R> R fetch(String idOrKeyProperty, String rawKind) {
        Class<?> kind = this.getKind(rawKind);
        Object idOrKey = ObjectifyModel.getFieldValue(this, idOrKeyProperty);
        if (idOrKey instanceof Long) {
            return (R)ObjectifyService.find(kind, (Long)idOrKey, false);
        }
        if (idOrKey instanceof String) {
            return (R)ObjectifyService.find(kind, (String)idOrKey, false);
        }
        if (idOrKey instanceof Key) {
            return (R)ObjectifyService.find((Key)idOrKey, false);
        }
        if (idOrKey != null) {
            throw new IllegalArgumentException("Id must be a Long, String, Key or null");
        }
        return null;
    }

    private Class<?> getKind(String rawKind) {
        if (rawKind.startsWith("models.")) {
            return ObjectifyService.loadClass(rawKind);
        }
        return ObjectifyService.loadClass("models." + this.capitalize(rawKind));
    }

    private static Object getFieldValue(Object object, String fieldName) {
        try {
            Field field = object.getClass().getField(fieldName);
            return field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reflectively get value for: " + fieldName);
        }
    }

    private String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }
}

