/*
 * Decompiled with CFR 0.152.
 */
package play.modules.objectify;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import play.Play;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.modules.gae.GAEPlugin;
import play.modules.objectify.ObjectifyBinder;
import play.modules.objectify.ObjectifyService;
import play.mvc.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectifyPlugin
extends PlayPlugin {
    protected static Boolean prod;

    protected void setup() {
        String models = Play.configuration.getProperty("objectify.models");
        if (models != null) {
            String[] modelsArray;
            for (String model : modelsArray = models.split(",")) {
                ObjectifyService.register("models." + model.trim());
            }
        }
    }

    protected boolean isProd() {
        if (prod == null) {
            List plugins = Play.plugins;
            for (PlayPlugin plugin : plugins) {
                if (!(plugin instanceof GAEPlugin)) continue;
                prod = ((GAEPlugin)plugin).prodGAE;
                return prod;
            }
            throw new IllegalStateException("Unable to determine GAE environment as GAEPlugin was not detected");
        }
        return prod;
    }

    public void onApplicationStart() {
        if (this.isProd()) {
            this.setup();
        }
    }

    public Object bind(String name, Class clazz, Type type, Map<String, String[]> params) {
        String binderClassName = Play.configuration.getProperty("objectify.binder", ObjectifyBinder.class.getName());
        try {
            Class binderClass = Play.classloader.loadClass(binderClassName);
            ObjectifyBinder binder = (ObjectifyBinder)binderClass.newInstance();
            Object result = binder.bind(name, clazz, type, params);
            return result == null ? super.bind(name, clazz, type, params) : result;
        }
        catch (Exception e) {
            throw new UnexpectedException("Unable to bind via binder: " + binderClassName + "," + e.getMessage(), (Throwable)e);
        }
    }

    public void beforeInvocation() {
        if (!this.isProd()) {
            this.setup();
        }
    }

    public void afterInvocation() {
        ObjectifyService.commitAll();
    }

    public void beforeActionInvocation(Method actionMethod) {
        Scope.RenderArgs renderArgs = Scope.RenderArgs.current();
        ObjectifyService objectifyService = new ObjectifyService();
        renderArgs.put("Datastore", (Object)objectifyService);
        renderArgs.put("ofy", (Object)objectifyService);
    }

    public void afterActionInvocation() {
    }

    public void onInvocationException(Throwable e) {
        ObjectifyService.rollbackAll();
    }

    public void invocationFinally() {
    }
}

