/*
 * Decompiled with CFR 0.152.
 */
package play.modules.objectify;

import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Transaction;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import play.modules.objectify.ObjectifyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectifyService {
    protected static ObjectifyFactory factory = new ObjectifyFactory();
    protected static List<Objectify> stack = new ArrayList<Objectify>();

    public static <T> T instantiate(Class<T> clazz) {
        return ObjectifyService.instantiate(clazz.getName());
    }

    public static <T> T instantiate(String className) {
        try {
            return ObjectifyFactory.loadClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create new instance of " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create new instance of " + className, e);
        }
    }

    public static <T> Map<Key<T>, T> get(Iterable<? extends Key<? extends T>> keys) {
        return ObjectifyService.objectify().get(keys);
    }

    public static <T> T get(Key<? extends T> key) throws EntityNotFoundException {
        return (T)ObjectifyService.objectify().get(key);
    }

    public static <T> T get(String className, Long id) throws EntityNotFoundException {
        return ObjectifyService.get(ObjectifyService.loadClass(className), id);
    }

    public static <T> T get(String className, String name) throws EntityNotFoundException {
        return ObjectifyService.get(ObjectifyService.loadClass(className), name);
    }

    public static <T> T get(Class<? extends T> clazz, Long id) throws EntityNotFoundException {
        return (T)ObjectifyService.objectify().get(clazz, id.longValue());
    }

    public static <T> T get(Class<? extends T> clazz, String name) throws EntityNotFoundException {
        return (T)ObjectifyService.objectify().get(clazz, name);
    }

    public static <S, T> Map<S, T> get(Class<? extends T> clazz, Iterable<S> idsOrNames) {
        return ObjectifyService.objectify().get(clazz, idsOrNames);
    }

    public static <T> T find(Key<? extends T> key, boolean newIfNull) {
        Object instance = null;
        if (key == null) {
            throw new IllegalArgumentException("Key may not be null");
        }
        if (key.getId() != 0L) {
            instance = ObjectifyService.objectify().find(key);
        }
        if (instance == null && newIfNull) {
            instance = ObjectifyService.instantiate(key.getKindClassName());
        }
        return (T)instance;
    }

    public static <T> T find(String className, Long id, boolean newIfNull) {
        return ObjectifyService.find(ObjectifyService.loadClass(className), id, newIfNull);
    }

    public static <T> T find(String className, String name, boolean newIfNull) {
        return ObjectifyService.find(ObjectifyService.loadClass(className), name, newIfNull);
    }

    public static <T> T find(Class<? extends T> clazz, Long id, boolean newIfNull) {
        Object instance = null;
        if (id != null && id != 0L) {
            instance = ObjectifyService.objectify().find(clazz, id.longValue());
        }
        if (instance == null && newIfNull) {
            instance = ObjectifyService.instantiate(clazz);
        }
        return (T)instance;
    }

    public static <T> T find(Class<? extends T> clazz, String name, boolean newIfNull) {
        Object instance = null;
        if (name != null && name.length() != 0) {
            instance = ObjectifyService.objectify().find(clazz, name);
        }
        if (instance == null && newIfNull) {
            instance = ObjectifyService.instantiate(clazz);
        }
        return (T)instance;
    }

    public static <T> Key<T> put(T obj) {
        return ObjectifyService.objectify().put(obj);
    }

    public static <T> Map<Key<T>, T> put(Iterable<? extends T> objs) {
        return ObjectifyService.objectify().put(objs);
    }

    public static void delete(Object keyOrEntity) {
        ObjectifyService.objectify().delete(keyOrEntity);
    }

    public static void delete(Iterable<?> keysOrEntities) {
        ObjectifyService.objectify().delete(keysOrEntities);
    }

    public static <T> void delete(Class<T> clazz, long id) {
        ObjectifyService.objectify().delete(clazz, id);
    }

    public static <T> void delete(Class<T> clazz, String name) {
        ObjectifyService.objectify().delete(clazz, name);
    }

    public static <T> Query<T> query() {
        return ObjectifyService.objectify().query();
    }

    public static <T> Query<T> query(Class<T> clazz) {
        return ObjectifyService.objectify().query(clazz);
    }

    public static ObjectifyFactory factory() {
        return factory;
    }

    public static Objectify objectify() {
        if (stack.isEmpty()) {
            ObjectifyService.begin();
        }
        return stack.get(0);
    }

    public static Objectify begin() {
        Objectify objectify = ObjectifyService.factory().begin();
        stack.add(0, objectify);
        return objectify;
    }

    public static Objectify beginTxn() {
        Objectify objectify = ObjectifyService.factory().beginTransaction();
        stack.add(0, objectify);
        return objectify;
    }

    public static void commit() {
        ObjectifyService.closeTxn(false);
    }

    public static void commitAll() {
        for (int i = 0; i < stack.size(); ++i) {
            ObjectifyService.closeTxn(false);
        }
    }

    public static void rollback() {
        ObjectifyService.closeTxn(true);
    }

    public static void rollbackAll() {
        for (int i = 0; i < stack.size(); ++i) {
            ObjectifyService.closeTxn(true);
        }
    }

    protected static void closeTxn(boolean rollback) {
        if (!stack.isEmpty()) {
            Objectify objectify = ObjectifyService.objectify();
            Transaction transaction = objectify.getTxn();
            if (transaction != null && transaction.isActive()) {
                if (rollback) {
                    transaction.rollback();
                } else {
                    transaction.commit();
                }
            }
            stack.remove(0);
        }
    }

    public static <T> Key<T> getKey(Object keyOrEntity) {
        return ObjectifyService.factory().getKey(keyOrEntity);
    }

    public static <T> Key<T> key(Object keyOrEntity) {
        return ObjectifyService.getKey(keyOrEntity);
    }

    public static <T> Key<T> getKey(Object ... pairs) {
        return ObjectifyService.factory().getKey(pairs);
    }

    public static <T> Key<T> key(Object ... pairs) {
        return ObjectifyService.getKey(pairs);
    }

    public static String getKeyStr(Object keyOrEntity) {
        return ObjectifyService.factory().getKeyStr(keyOrEntity);
    }

    public static String keyStr(Object keyOrEntity) {
        return ObjectifyService.getKeyStr(keyOrEntity);
    }

    public static void register(Class<?> clazz) {
        ObjectifyService.factory().register(clazz);
    }

    public static void register(String className) {
        ObjectifyService.factory().register(ObjectifyService.loadClass(className));
    }

    public static <T> Class<T> loadClass(Class<T> clazz) {
        return ObjectifyService.loadClass(clazz.getName());
    }

    public static <T> Class<T> loadClass(String className) {
        if (className.startsWith("models.")) {
            return ObjectifyFactory.loadClass(className);
        }
        return ObjectifyFactory.loadClass("models." + className);
    }

    public static void setDatastoreTimeoutRetryCount(int value) {
        ObjectifyService.factory().setDatastoreTimeoutRetryCount(value);
    }

    public static int getDatastoreTimeoutRetryCount() {
        return ObjectifyService.factory().getDatastoreTimeoutRetryCount();
    }
}

