/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Key<T>
implements Serializable,
Comparable<Key<?>> {
    private static final long serialVersionUID = 1L;
    protected String kindClassName;
    protected Key<?> parent;
    protected long id;
    protected String name;

    protected Key() {
    }

    public Key(Class<? extends T> kind, long id) {
        this(null, kind, id);
    }

    public Key(Class<? extends T> kind, String name) {
        this(null, kind, name);
    }

    public Key(Key<?> parent, Class<? extends T> kind, long id) {
        this.parent = parent;
        this.kindClassName = kind.getName();
        this.id = id;
    }

    public Key(Key<?> parent, Class<? extends T> kind, String name) {
        this.parent = parent;
        this.kindClassName = kind.getName();
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKindClassName() {
        return this.kindClassName;
    }

    public <V> Key<V> getParent() {
        return this.parent;
    }

    @Override
    public int compareTo(Key<?> other) {
        int cmp = this.kindClassName.compareTo(other.kindClassName);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Key.compareNullable(this.parent, other.parent);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Key.compareNullable((Comparable)((Object)this.name), (Comparable)((Object)other.name));
        if (cmp != 0) {
            return cmp;
        }
        if (this.id < other.id) {
            return -1;
        }
        if (this.id > other.id) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        return this.compareTo((Key)obj) == 0;
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return (int)this.id;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("Key{kindClassName=");
        bld.append(this.kindClassName);
        bld.append(", parent=");
        bld.append(this.parent);
        if (this.name != null) {
            bld.append(", name=");
            bld.append(this.name);
        } else {
            bld.append(", id=");
            bld.append(this.id);
        }
        bld.append("}");
        return bld.toString();
    }

    private static int compareNullable(Comparable o1, Comparable o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }
}

