/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Transaction;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.annotation.Entity;
import com.googlecode.objectify.impl.CachingDatastoreService;
import com.googlecode.objectify.impl.DatastoreTimeoutRetryProxy;
import com.googlecode.objectify.impl.EntityMetadata;
import com.googlecode.objectify.impl.ObjectifyImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectifyFactory {
    protected Map<String, EntityMetadata<?>> types = new ConcurrentHashMap();
    protected int datastoreTimeoutRetryCount;
    protected boolean useCachingDatastoreService;

    protected Objectify createObjectify(DatastoreService ds, Transaction txn) {
        return new ObjectifyImpl(this, ds, txn);
    }

    protected DatastoreService getDatastoreService() {
        if (this.useCachingDatastoreService) {
            return new CachingDatastoreService(this, this.getRawDatastoreService());
        }
        return this.getRawDatastoreService();
    }

    protected DatastoreService getRawDatastoreService() {
        return DatastoreServiceFactory.getDatastoreService();
    }

    public Objectify begin() {
        DatastoreService ds = this.getDatastoreService();
        Objectify impl = this.createObjectify(ds, null);
        return this.maybeWrap(impl);
    }

    public Objectify beginTransaction() {
        DatastoreService ds = this.getDatastoreService();
        Objectify impl = this.createObjectify(ds, ds.beginTransaction());
        return this.maybeWrap(impl);
    }

    public Objectify withTransaction(Transaction txn) {
        DatastoreService ds = this.getDatastoreService();
        return this.maybeWrap(this.createObjectify(ds, txn));
    }

    public <T> void register(Class<T> clazz) {
        String kind = this.getKind(clazz);
        EntityMetadata<T> meta = new EntityMetadata<T>(this, clazz);
        this.types.put(kind, meta);
        if (meta.getCached() != null) {
            this.useCachingDatastoreService = true;
        }
    }

    public void setDatastoreTimeoutRetryCount(int value) {
        this.datastoreTimeoutRetryCount = value;
    }

    public int getDatastoreTimeoutRetryCount() {
        return this.datastoreTimeoutRetryCount;
    }

    public <T> T maybeWrap(T impl) {
        if (this.datastoreTimeoutRetryCount > 0) {
            return DatastoreTimeoutRetryProxy.wrap(impl, this.datastoreTimeoutRetryCount);
        }
        return impl;
    }

    public String getKind(Class<?> clazz) {
        Entity ourAnn = clazz.getAnnotation(Entity.class);
        if (ourAnn != null && ourAnn.name() != null && ourAnn.name().length() != 0) {
            return ourAnn.name();
        }
        javax.persistence.Entity jpaAnn = clazz.getAnnotation(javax.persistence.Entity.class);
        if (jpaAnn != null && jpaAnn.name() != null && jpaAnn.name().length() != 0) {
            return jpaAnn.name();
        }
        return clazz.getSimpleName();
    }

    public String getKind(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return this.getKind(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> EntityMetadata<T> getMetadata(com.google.appengine.api.datastore.Key key) {
        return this.getMetadata(key.getKind());
    }

    public <T> EntityMetadata<T> getMetadata(Key<T> key) {
        return this.getMetadata(this.getKind(key.getKindClassName()));
    }

    public <T> EntityMetadata<? extends T> getMetadata(Class<T> clazz) {
        return this.getMetadata(this.getKind(clazz));
    }

    public <T> EntityMetadata<T> getMetadataForEntity(T obj) {
        return this.getMetadata(obj.getClass());
    }

    protected <T> EntityMetadata<T> getMetadata(String kind) {
        EntityMetadata<?> metadata = this.types.get(kind);
        if (metadata == null) {
            throw new IllegalArgumentException("No registered type for kind " + kind);
        }
        return metadata;
    }

    public com.google.appengine.api.datastore.Key typedKeyToRawKey(Key<?> typedKey) {
        if (typedKey == null) {
            return null;
        }
        if (typedKey.getName() != null) {
            return KeyFactory.createKey((com.google.appengine.api.datastore.Key)this.typedKeyToRawKey(typedKey.getParent()), (String)this.getKind(typedKey.getKindClassName()), (String)typedKey.getName());
        }
        return KeyFactory.createKey((com.google.appengine.api.datastore.Key)this.typedKeyToRawKey(typedKey.getParent()), (String)this.getKind(typedKey.getKindClassName()), (long)typedKey.getId());
    }

    public <T> Key<T> rawKeyToTypedKey(com.google.appengine.api.datastore.Key rawKey) {
        if (rawKey == null) {
            return null;
        }
        EntityMetadata<T> meta = this.getMetadata(rawKey);
        Class<T> entityClass = meta.getEntityClass();
        if (rawKey.getName() != null) {
            return new Key<T>(this.rawKeyToTypedKey(rawKey.getParent()), entityClass, rawKey.getName());
        }
        return new Key<T>(this.rawKeyToTypedKey(rawKey.getParent()), entityClass, rawKey.getId());
    }

    public <T> Key<T> getKey(Object keyOrEntity) {
        if (keyOrEntity instanceof com.google.appengine.api.datastore.Key) {
            return this.rawKeyToTypedKey((com.google.appengine.api.datastore.Key)keyOrEntity);
        }
        if (keyOrEntity instanceof Key) {
            return (Key)keyOrEntity;
        }
        return this.rawKeyToTypedKey(this.getMetadataForEntity(keyOrEntity).getKey(keyOrEntity));
    }

    public com.google.appengine.api.datastore.Key getRawKey(Object keyOrEntity) {
        if (keyOrEntity instanceof com.google.appengine.api.datastore.Key) {
            return (com.google.appengine.api.datastore.Key)keyOrEntity;
        }
        if (keyOrEntity instanceof Key) {
            return this.typedKeyToRawKey((Key)keyOrEntity);
        }
        return this.getMetadataForEntity(keyOrEntity).getKey(keyOrEntity);
    }

    public Object makeFilterable(Object keyOrEntityOrOther) {
        if (keyOrEntityOrOther == null) {
            return null;
        }
        if (keyOrEntityOrOther instanceof Key) {
            return this.typedKeyToRawKey((Key)keyOrEntityOrOther);
        }
        String kind = this.getKind(keyOrEntityOrOther.getClass());
        EntityMetadata<?> meta = this.types.get(kind);
        if (meta == null) {
            return keyOrEntityOrOther;
        }
        return meta.getKey(keyOrEntityOrOther);
    }
}

