/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.helper;

import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.Query;
import com.googlecode.objectify.helper.ObjectifyWrapper;
import com.googlecode.objectify.helper.QueryResultIteratorWrapper;
import com.googlecode.objectify.helper.QueryWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingObjectify
extends ObjectifyWrapper {
    private static final Object NEGATIVE_RESULT = new Object();
    private Map<Key<?>, Object> cache = new HashMap();

    public CachingObjectify(Objectify ofy) {
        super(ofy);
    }

    @Override
    public <T> Map<Key<T>, T> get(Iterable<? extends Key<? extends T>> keys) {
        ArrayList<Key<T>> needFetching = new ArrayList<Key<T>>();
        for (Key<T> key : keys) {
            if (this.cache.containsKey(key)) continue;
            needFetching.add(key);
        }
        Map fetched = super.get(needFetching);
        LinkedHashMap<Key<T>, Object> linkedHashMap = new LinkedHashMap<Key<T>, Object>();
        for (Key<T> key : keys) {
            Object t = this.cache.get(key);
            if (t != null) {
                if (t == NEGATIVE_RESULT) continue;
                linkedHashMap.put(key, t);
                continue;
            }
            t = fetched.get(key);
            if (t != null) {
                linkedHashMap.put(key, t);
                this.cache.put(key, t);
                continue;
            }
            this.cache.put(key, NEGATIVE_RESULT);
        }
        return linkedHashMap;
    }

    @Override
    public <T> T get(Key<? extends T> key) throws EntityNotFoundException {
        T t = this.find(key);
        if (t == null) {
            throw new EntityNotFoundException(this.getFactory().getRawKey(key));
        }
        return t;
    }

    @Override
    public <T> T get(Class<? extends T> clazz, long id) throws EntityNotFoundException {
        return this.get(new Key<T>(clazz, id));
    }

    @Override
    public <T> T get(Class<? extends T> clazz, String name) throws EntityNotFoundException {
        return this.get(new Key<T>(clazz, name));
    }

    @Override
    public <S, T> Map<S, T> get(Class<? extends T> clazz, Iterable<S> idsOrNames) {
        ArrayList<Key<? extends T>> keys = new ArrayList<Key<? extends T>>();
        for (S id : idsOrNames) {
            if (id instanceof Long) {
                keys.add(new Key<T>(clazz, (Long)id));
                continue;
            }
            if (id instanceof String) {
                keys.add(new Key<T>(clazz, (String)id));
                continue;
            }
            throw new IllegalArgumentException("Only Long or String is allowed, not " + id.getClass().getName() + " (" + id + ")");
        }
        Map<Key<T>, T> fetched = this.get(keys);
        LinkedHashMap<Object, T> result = new LinkedHashMap<Object, T>(fetched.size() * 2);
        for (Map.Entry<Key<T>, T> entry : fetched.entrySet()) {
            Object mapKey = entry.getKey().getName() != null ? entry.getKey().getName() : Long.valueOf(entry.getKey().getId());
            result.put(mapKey, entry.getValue());
        }
        return result;
    }

    @Override
    public <T> T find(Key<? extends T> key) {
        Object t = this.cache.get(key);
        if (t != null) {
            return (T)(t == NEGATIVE_RESULT ? null : t);
        }
        t = super.find(key);
        if (t == null) {
            this.cache.put(key, NEGATIVE_RESULT);
        } else {
            this.cache.put(key, t);
        }
        return (T)t;
    }

    @Override
    public <T> T find(Class<? extends T> clazz, long id) {
        return this.find(new Key<T>(clazz, id));
    }

    @Override
    public <T> T find(Class<? extends T> clazz, String name) {
        return this.find(new Key<T>(clazz, name));
    }

    @Override
    public <T> Key<T> put(T obj) {
        Key<T> key = super.put(obj);
        this.cache.put(key, obj);
        return key;
    }

    @Override
    public <T> Map<Key<T>, T> put(Iterable<? extends T> objs) {
        Map<Key<? extends T>, ? extends T> result = super.put(objs);
        this.cache.putAll(result);
        return result;
    }

    @Override
    public void delete(Object keyOrEntity) {
        super.delete(keyOrEntity);
        Key key = this.getFactory().getKey(keyOrEntity);
        this.cache.put(key, NEGATIVE_RESULT);
    }

    @Override
    public void delete(Iterable<?> keysOrEntities) {
        super.delete(keysOrEntities);
        for (Object obj : keysOrEntities) {
            this.cache.put(this.getFactory().getKey(obj), NEGATIVE_RESULT);
        }
    }

    @Override
    public <T> void delete(Class<T> clazz, long id) {
        this.delete(new Key<T>(clazz, id));
    }

    @Override
    public <T> void delete(Class<T> clazz, String name) {
        this.delete(new Key<T>(clazz, name));
    }

    @Override
    public <T> Query<T> query() {
        return new CachingQuery(super.query());
    }

    @Override
    public <T> Query<T> query(Class<T> clazz) {
        return new CachingQuery<T>(super.query(clazz));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CachingQueryResultIterator<T>
    extends QueryResultIteratorWrapper<T> {
        public CachingQueryResultIterator(QueryResultIterator<T> base) {
            super(base);
        }

        @Override
        public T next() {
            Object t = super.next();
            CachingObjectify.this.cache.put(CachingObjectify.this.getFactory().getKey(t), t);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CachingQuery<T>
    extends QueryWrapper<T> {
        public CachingQuery(Query<T> base) {
            super(base);
        }

        @Override
        public QueryResultIterable<T> fetch() {
            return new QueryResultIterable<T>(){

                public QueryResultIterator<T> iterator() {
                    return CachingQuery.this.iterator();
                }
            };
        }

        @Override
        public <V> Map<Key<V>, V> fetchParents() {
            Map result = super.fetchParents();
            CachingObjectify.this.cache.putAll(result);
            return result;
        }

        @Override
        public T get() {
            Object t = super.get();
            CachingObjectify.this.cache.put(CachingObjectify.this.getFactory().getKey(t), t);
            return t;
        }

        @Override
        public QueryResultIterator<T> iterator() {
            return new CachingQueryResultIterator(super.iterator());
        }
    }
}

