/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.annotation.Cached;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDatastoreService
implements DatastoreService {
    public static final String MEMCACHE_NAMESPACE = "Objectify Cache";
    ObjectifyFactory fact;
    DatastoreService raw;
    MemcacheService memcache;

    public CachingDatastoreService(ObjectifyFactory fact, DatastoreService raw) {
        this.fact = fact;
        this.raw = raw;
    }

    protected MemcacheService getMemcache() {
        if (this.memcache == null) {
            this.memcache = MemcacheServiceFactory.getMemcacheService();
            this.memcache.setNamespace(MEMCACHE_NAMESPACE);
        }
        return this.memcache;
    }

    private Map<Integer, Map<Key, Entity>> categorize(Map<Key, Entity> entities) {
        HashMap<Integer, Map<Key, Entity>> result = new HashMap<Integer, Map<Key, Entity>>();
        for (Map.Entry<Key, Entity> entry : entities.entrySet()) {
            Cached cachedAnno = this.fact.getMetadata(entry.getKey()).getCached();
            if (cachedAnno == null) continue;
            Integer expiry = cachedAnno.expirationSeconds();
            HashMap<Key, Entity> grouping = (HashMap<Key, Entity>)result.get(expiry);
            if (grouping == null) {
                grouping = new HashMap<Key, Entity>();
                result.put(expiry, grouping);
            }
            grouping.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Map<Key, Entity> getFromDatastore(Transaction txn, Set<Key> stillNeeded) {
        Map result = this.raw.get(txn, stillNeeded);
        if (result.size() != stillNeeded.size()) {
            for (Key key : stillNeeded) {
                if (result.containsKey(key)) continue;
                result.put(key, null);
            }
        }
        return result;
    }

    private Map<Key, Entity> getFromCacheRaw(Iterable<Key> keys) {
        ArrayList<Key> keysColl;
        if (keys instanceof Collection) {
            keysColl = (ArrayList<Key>)keys;
        } else {
            keysColl = new ArrayList<Key>();
            for (Key key : keys) {
                keysColl.add(key);
            }
        }
        return this.getMemcache().getAll(keysColl);
    }

    private Map<Key, Entity> getFromCache(Iterable<Key> keys) {
        ArrayList<Key> fetch = new ArrayList<Key>();
        for (Key key : keys) {
            if (this.fact.getMetadata(key).getCached() == null) continue;
            fetch.add(key);
        }
        return this.getFromCacheRaw(fetch);
    }

    private void putInCache(Map<Key, Entity> entities, int expirationSeconds) {
        if (expirationSeconds < 0) {
            this.getMemcache().putAll(entities);
        } else {
            this.getMemcache().putAll(entities, Expiration.byDeltaSeconds((int)expirationSeconds));
        }
    }

    private void putInCache(Map<Key, Entity> entities) {
        Map<Integer, Map<Key, Entity>> categories = this.categorize(entities);
        for (Map.Entry<Integer, Map<Key, Entity>> entry : categories.entrySet()) {
            this.putInCache(entry.getValue(), entry.getKey());
        }
    }

    private void deleteFromCache(Iterable<Key> keys) {
        ArrayList<Key> cacheables = new ArrayList<Key>();
        for (Key key : keys) {
            if (this.fact.getMetadata(key).getCached() == null) continue;
            cacheables.add(key);
        }
        if (!cacheables.isEmpty()) {
            this.getMemcache().deleteAll(cacheables);
        }
    }

    public KeyRange allocateIds(String kind, long num) {
        return this.raw.allocateIds(kind, num);
    }

    public KeyRange allocateIds(Key parent, String kind, long num) {
        return this.raw.allocateIds(parent, kind, num);
    }

    public Transaction beginTransaction() {
        return new TransactionWrapper(this.raw.beginTransaction());
    }

    public void delete(Key ... keys) {
        this.delete((Transaction)null, keys);
    }

    public void delete(Iterable<Key> keys) {
        this.delete(null, keys);
    }

    public void delete(Transaction txn, Key ... keys) {
        this.delete(txn, Arrays.asList(keys));
    }

    public void delete(Transaction txn, Iterable<Key> keys) {
        this.raw.delete(txn, keys);
        if (txn != null) {
            for (Key key : keys) {
                ((TransactionWrapper)txn).deferCacheDelete(key);
            }
        } else {
            this.deleteFromCache(keys);
        }
    }

    public Entity get(Key key) throws EntityNotFoundException {
        return this.get(null, key);
    }

    public Map<Key, Entity> get(Iterable<Key> keys) {
        return this.get(null, keys);
    }

    public Entity get(Transaction txn, Key key) throws EntityNotFoundException {
        Cached cachedAnnotation = this.fact.getMetadata(key).getCached();
        if (txn != null || cachedAnnotation == null) {
            return this.raw.get(txn, key);
        }
        Map<Key, Entity> map = this.getFromCacheRaw(Collections.singleton(key));
        if (map.isEmpty()) {
            try {
                Entity ent = this.raw.get(txn, key);
                map.put(key, ent);
                this.putInCache(map, cachedAnnotation.expirationSeconds());
                return ent;
            }
            catch (EntityNotFoundException e) {
                map.put(key, null);
                this.putInCache(map, cachedAnnotation.expirationSeconds());
                throw e;
            }
        }
        Entity result = map.values().iterator().next();
        if (result == null) {
            throw new EntityNotFoundException(key);
        }
        return result;
    }

    public Map<Key, Entity> get(Transaction txn, Iterable<Key> keys) {
        if (txn != null) {
            return this.raw.get(txn, keys);
        }
        Map<Key, Entity> soFar = this.getFromCache(keys);
        HashSet<Key> stillNeeded = new HashSet<Key>();
        for (Key getKey : keys) {
            if (soFar.containsKey(getKey)) continue;
            stillNeeded.add(getKey);
        }
        if (!stillNeeded.isEmpty()) {
            Map<Key, Entity> fetched = this.getFromDatastore(txn, stillNeeded);
            soFar.putAll(fetched);
            this.putInCache(fetched);
        }
        Iterator<Entity> it = soFar.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        return soFar;
    }

    public Collection<Transaction> getActiveTransactions() {
        return this.raw.getActiveTransactions();
    }

    public Transaction getCurrentTransaction() {
        return this.raw.getCurrentTransaction();
    }

    public Transaction getCurrentTransaction(Transaction txn) {
        return this.raw.getCurrentTransaction(txn);
    }

    public PreparedQuery prepare(Query query) {
        return this.raw.prepare(query);
    }

    public PreparedQuery prepare(Transaction txn, Query query) {
        return this.raw.prepare(txn, query);
    }

    public Key put(Entity entity) {
        return this.put(null, entity);
    }

    public List<Key> put(Iterable<Entity> entities) {
        return this.put(null, entities);
    }

    public Key put(Transaction txn, Entity entity) {
        Key result = this.raw.put(txn, entity);
        if (txn != null) {
            ((TransactionWrapper)txn).deferCachePut(entity);
        } else {
            this.putInCache(Collections.singletonMap(entity.getKey(), entity));
        }
        return result;
    }

    public List<Key> put(Transaction txn, Iterable<Entity> entities) {
        List result = this.raw.put(txn, entities);
        if (txn != null) {
            for (Entity ent : entities) {
                ((TransactionWrapper)txn).deferCachePut(ent);
            }
        } else {
            HashMap<Key, Entity> map = new HashMap<Key, Entity>();
            for (Entity entity : entities) {
                map.put(entity.getKey(), entity);
            }
            this.putInCache(map);
        }
        return result;
    }

    class TransactionWrapper
    implements Transaction {
        Transaction raw;
        Set<Key> deferredDeletes;
        Map<Key, Entity> deferredPuts;

        public TransactionWrapper(Transaction raw) {
            this.raw = raw;
        }

        public void commit() {
            this.raw.commit();
            if (this.deferredDeletes != null) {
                CachingDatastoreService.this.getMemcache().deleteAll(this.deferredDeletes);
            }
            if (this.deferredPuts != null) {
                CachingDatastoreService.this.getMemcache().putAll(this.deferredPuts);
            }
        }

        public String getId() {
            return this.raw.getId();
        }

        public boolean isActive() {
            return this.raw.isActive();
        }

        public void rollback() {
            this.raw.rollback();
        }

        public String getApp() {
            return this.raw.getApp();
        }

        public void deferCacheDelete(Key key) {
            Cached cachedAnno = CachingDatastoreService.this.fact.getMetadata(key).getCached();
            if (cachedAnno == null) {
                return;
            }
            if (this.deferredPuts != null) {
                this.deferredPuts.remove(key);
            }
            if (this.deferredDeletes == null) {
                this.deferredDeletes = new HashSet<Key>();
            }
            this.deferredDeletes.add(key);
        }

        public void deferCachePut(Entity entity) {
            Cached cachedAnno = CachingDatastoreService.this.fact.getMetadata(entity.getKey()).getCached();
            if (cachedAnno == null) {
                return;
            }
            Key key = entity.getKey();
            if (this.deferredDeletes != null) {
                this.deferredDeletes.remove(key);
            }
            if (this.deferredPuts == null) {
                this.deferredPuts = new HashMap<Key, Entity>();
            }
            this.deferredPuts.put(key, entity);
        }
    }
}

